/**
 * Copyright misinoe ( http://wonderfl.net/user/misinoe )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/27xE
 */

package {
    import flash.display.Bitmap;
    import flash.text.TextField;
    import flash.display.BitmapData;
    import flash.display.Shape;
    import flash.geom.Matrix;
    import flash.display.Sprite;
    import flash.events.MouseEvent;
    // お絵かき系の練習
    public class FlashTest extends Sprite {
        
        //
        private var _gradientSprite:Sprite;    // グラデ描画用Spriteです
        private var _alphaSprite:Sprite;    // アルファ値決定用のSpriteです
        
        private var _forcusCanvas:Sprite;    // 現在の書き込まれる対象の参照
        private var _alpha:Number = 1.0;    // 不透明度です。0.0～1.0
        private var _color:uint = 0;    // 書き込まれる色です。0～255
        
        private var _canvas:Sprite;    // キャンバスの背景とか担当
        private var _canvas1:Sprite;    // 書き込まれる子
        private var _canvas2:Sprite;
        private var _canvas3:Sprite;
        
        
        
        private var _debugTF:TextField;   // デバッグ用のテキストフィールドさん
        
        public function FlashTest() {
            // write as3 code here..
            
            
            // キャンヴァスの作成とハンドリング
            this.addChild( this._canvas = new Sprite() );
            this._canvas.addChild( this._canvas1 = new Sprite() );
            this._canvas.addChild( this._canvas2 = new Sprite() );
            this._canvas.addChild( this._canvas3 = new Sprite() );
            // 背景の描画
            this._canvas.graphics.lineStyle(0);
            this._canvas.graphics.beginFill(0xFFFFFF, 1 );
            this._canvas.graphics.drawRect( 5,5,stage.stageWidth-10,stage.stageHeight-10 );
            this._canvas.graphics.endFill();
            // イベントハンドリング
            var canvasMouseMoveHandler:Function = function(e:MouseEvent):void{
                var target:Sprite = _forcusCanvas; // e.target as Sprite;
                target.graphics.lineTo( target.mouseX, target.mouseY );
                e.updateAfterEvent();
            };
            var canvasMouseUpHandler:Function = function(e:MouseEvent):void{
                stage.removeEventListener( MouseEvent.MOUSE_MOVE, canvasMouseMoveHandler );
                stage.removeEventListener( MouseEvent.MOUSE_UP, canvasMouseUpHandler );
            };
            var canvasMouseDownHandler:Function = function(e:MouseEvent):void{
                var target:Sprite = _forcusCanvas; // e.target as Sprite;
                target.graphics.lineStyle( 4, _color, _alpha );
                target.graphics.moveTo( target.mouseX, target.mouseY );
                stage.addEventListener( MouseEvent.MOUSE_MOVE, canvasMouseMoveHandler );
                stage.addEventListener( MouseEvent.MOUSE_UP, canvasMouseUpHandler );
            };
            this._canvas.addEventListener( MouseEvent.MOUSE_DOWN, canvasMouseDownHandler );
            
            
            // レイヤーの選択
            var layer1Tf:TextField = new TextField();
            this.addChild( layer1Tf );
            var layer2Tf:TextField = new TextField();
            this.addChild( layer2Tf );
            var layer3Tf:TextField = new TextField();
            this.addChild( layer3Tf );
            layer1Tf.selectable = layer2Tf.selectable = layer3Tf.selectable = false;
            layer1Tf.border = layer2Tf.border = layer3Tf.border = true;
            layer1Tf.background = layer2Tf.background = layer3Tf.background = true;
            layer1Tf.width = layer2Tf.width = layer3Tf.width = 48;
            layer1Tf.height = layer2Tf.height = layer3Tf.height = 22;
            // 移動
            layer1Tf.x = 300;
            layer2Tf.x = 350;
            layer3Tf.x = 400;
            // ラベル
            layer1Tf.text = "Layer 1";
            layer2Tf.text = "Layer 2";
            layer3Tf.text = "Layer 3";
            // イベントハンドリング。
            layer1Tf.addEventListener( MouseEvent.CLICK, function(...args):void{ _forcusCanvas = _canvas1; layer1Tf.backgroundColor=0xFFFFFF; layer2Tf.backgroundColor=layer3Tf.backgroundColor=0xCCCCCC; } );
            layer2Tf.addEventListener( MouseEvent.CLICK, function(...args):void{ _forcusCanvas = _canvas2; layer2Tf.backgroundColor=0xFFFFFF; layer1Tf.backgroundColor=layer3Tf.backgroundColor=0xCCCCCC; } );
            layer3Tf.addEventListener( MouseEvent.CLICK, function(...args):void{ _forcusCanvas = _canvas3; layer3Tf.backgroundColor=0xFFFFFF; layer1Tf.backgroundColor=layer2Tf.backgroundColor=0xCCCCCC; } );
            layer1Tf.dispatchEvent( new MouseEvent( MouseEvent.CLICK ) );


            // グラデーション用のスプライトの作成と、イベントハンドリングを行います
            this.addChild( this._gradientSprite = new Sprite() );
            this._drawGradient();
            var gradientMouseMoveHandler:Function = function(e:MouseEvent):void{
                var bitmapData:BitmapData = new BitmapData(1,1,true,0);
                var m:Matrix = new Matrix();
                m.tx = -stage.mouseX;
                m.ty = -stage.mouseY;
                bitmapData.draw( _gradientSprite, m );
                var col:uint = bitmapData.getPixel32(0,0);
                _setColor32( col );    // ここで色を設定してます
                bitmapData.dispose();
                e.updateAfterEvent();
            };
            var gradientMouseUpHandler:Function = function(...args):void{
                stage.removeEventListener( MouseEvent.MOUSE_MOVE, gradientMouseMoveHandler );
                stage.removeEventListener( MouseEvent.MOUSE_UP, gradientMouseUpHandler );
            };
            var gradientMouseDownHandler:Function = function(...args):void{
                stage.addEventListener( MouseEvent.MOUSE_MOVE, gradientMouseMoveHandler );
                stage.addEventListener( MouseEvent.MOUSE_UP, gradientMouseUpHandler );
            };
            this._gradientSprite.addEventListener( MouseEvent.MOUSE_DOWN, gradientMouseDownHandler );
            
            
            // アルファ値決定用のスプライトとそのイベントハンドリングです、まだ無い
            
            
         　 // マウスホイール操作
         　 var stageMouseWheelHandler:Function = function( e:MouseEvent ):void{
         　     if( e.delta>0 ) _canvas.scaleX = _canvas.scaleY += _canvas.scaleY/10;
         　     else _canvas.scaleX = _canvas.scaleY -= _canvas.scaleY/10;
         　 };
         　 stage.addEventListener( MouseEvent.MOUSE_WHEEL, stageMouseWheelHandler );
         　     
            

           // デバグ
           // this.addChild( this._debugTF = new TextField() );
           // this._debugTF.y = 50;
        };
        
        // グラデを再描画
        private function _drawGradient():void{
            var w:uint = 200;
            var h:uint = 10;
            var m:Matrix;
            with( this._gradientSprite.graphics ){
                 clear(); 
                 lineStyle( 0 );
                 m = new Matrix();
                 m.createGradientBox(w,h,0,0,0);
                 beginGradientFill( flash.display.GradientType.LINEAR, [0xFF0000,0xFF00,0xFF],[1,1,1],[0,0x88,0xFF],m );
                 drawRect( 0,0, w, h );
            };
        };
        
        // 色を決定
        private function _setColor32( color32:uint ):void{
            if( color32==0 ) return;
            this._color = color32&0xFFFFFF;
            this._alpha = 1.0;//((color32>>24)&0xFF)/0xFF;
        };


    }
}