/**
 * Copyright hig_an ( http://wonderfl.net/user/hig_an )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/27kA
 */

package {
    import flash.display.Sprite;
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.filters.BlurFilter;
	import flash.geom.Point;
    
    public class FlashTest extends Sprite {
        private var bmpdata:BitmapData;
		private var particles:Array;
		private var size:Number = 465;
		private var particle_number:uint = 0;
		private var filter:BlurFilter;
		private var limit:uint = 1000;
		
		public function FlashTest() {
			bmpdata = new BitmapData(size, size, false, 0);
			addChild(new Bitmap(bmpdata));
			particles = new Array();
			filter = new BlurFilter(3, 10, 100);
			
			reset();
            addEventListener(Event.ENTER_FRAME, explosion);
			stage.addEventListener(MouseEvent.CLICK, reset);
        }
		public function reset(e:MouseEvent = null):void {
			var pt:Point = new Point(mouseX, mouseY);
			particle_number += 1000;
			for (var i:int = 0; i < particle_number; i++) {
				particles[i] = new Particle(pt.x, pt.y);
			}
		}
		public function enterframe(e:Event):void {
			bmpdata.applyFilter(bmpdata, bmpdata.rect, bmpdata.rect.topLeft, filter);
			bmpdata.lock();
			for (var i:int = 0; i < particle_number; i++) {
				var p:Particle = particles[i];
				
				
				p.deg = (p.deg + p.angle) % 360;
				
				p.x = p.diff * Math.cos(p.deg * Math.PI / 180) + mouseX;
				p.y = p.diff * Math.sin(p.deg * Math.PI / 180) + mouseY;
				
				bmpdata.setPixel(p.x, p.y,0x00ff00);
			}
			bmpdata.unlock();
		}
		public function explosion(e:Event):void {
			bmpdata.applyFilter(bmpdata, bmpdata.rect, bmpdata.rect.topLeft, filter);
			bmpdata.lock();
			for (var i:int = 0; i < particle_number; i++) {
				var p:Particle = particles[i];
				
				
				p.deg = (p.deg + p.angle) % 360;
				
				
				
				p.x += p.vvx;
				p.y += p.vvy;
				
				if (p.x > size) { p.x -= size; }
                else if (p.x < 0) { p.x += size; }
                if (p.y > size) { p.y -= size; }
                else if (p.y < 0) { p.y += size; }
				
				bmpdata.setPixel(p.x, p.y, 0x00ff00);

			}
			bmpdata.unlock();
		}
    }
}

class Particle {
	public var x:Number;
	public var y:Number;
	
	public var vx:Number = 0;
	public var vy:Number = 0;	
	public var vvx:Number = 0;
	public var vvy:Number = 0;
	
	public var ax:Number = 0;
	public var ay:Number = 0;
	
	public var angle:uint = 0;
	public var diff:uint = 0;
	public var deg:uint = 0;
	
	function Particle(px:Number,py:Number) {
		x = px;
		y = py;
		
		angle = 5 + 20 * Math.random();
		diff = 50 + 40 * Math.random();
		
		vvx = 5 - Math.random() * 10;
		vvy = 5 - Math.random() * 10;
	}
}