/**
 * Copyright demouth ( http://wonderfl.net/user/demouth )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/27cT
 */

// forked from mtok's forked from: forked from: flash on 2009-10-17
package  
{
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Graphics;
	import flash.display.Shape;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.geom.Matrix;
	import flash.display.BlendMode;
	import flash.utils.getTimer;
	/**
	 * ...
	 * @author Motoki Matsumoto
	 */
	public class DisplacementFilterTest extends Sprite
	{
		private var bg:Bitmap;
		private var fore:Sprite;
		public function DisplacementFilterTest() 
		{
			addEventListener(Event.ADDED_TO_STAGE, addedToStageHandler);
		}
		
		private function addedToStageHandler(e:Event):void 
		{
			removeEventListener(Event.ADDED_TO_STAGE, addedToStageHandler);
			
			addChild(bg = new Bitmap(new BitmapData(stage.stageWidth, stage.stageHeight)));
			addChild(fore = new Sprite());
			
			drawBackground();
			
			addEventListener(Event.ENTER_FRAME , enterFrameHandler);
		}
		
		private function drawBackground():void
		{
			var bg:Bitmap = this.bg;
			var r:Number = 30;
			var fig:Shape = drawCircle(20, 3);
			var mat:Matrix = new Matrix();
			
			var i:int, j:int;
			for (i = int(0.5 * stage.stageHeight / r) + 5; i > -1 ; i--) {
				for (j = int(0.5 * stage.stageWidth / r) + 5; j > -1; j--) {
					mat.tx = j * 1.5*r + Math.random() * 20 - 10;
					mat.ty = i * 1.5*r + Math.random() * 20 - 10;
					bg.bitmapData.draw(fig, mat,null, BlendMode.DARKEN);
				}
			}
			for (i = 0; i < 0; i++) {
				mat.tx = Math.random() * 465;
				mat.ty = Math.random() * 465;
				bg.bitmapData.draw(fig, mat,null, BlendMode.DARKEN);
			}
		}
		
		private function drawCircle(radius:Number, space:Number):Shape
		{
			var fig:Shape = new Shape();
			var g:Graphics = fig.graphics;
			g.beginFill(0xffffff);
			g.drawCircle(0, 0, radius);
			g.endFill();
			
			g.lineStyle(1, 0);
			var len:int = Math.floor(radius / 2);
			var r:Number = radius;
			while (r > 0) {
				g.drawCircle(0, 0, r);
				r -= space;
			}
			
			return fig;
		}
		
		private function enterFrameHandler(e:Event):void 
		{
			var r:Number = 5;
			var rad:Number = (getTimer()*0.6 % 360) * Math.PI / 180;
			this.x = Math.sin(rad) * r;
			this.y = Math.cos(rad) * r;
		}
		
	}

}