/**
 * Copyright wh0 ( http://wonderfl.net/user/wh0 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/27TT
 */

package {
    import flash.display.*;
    import flash.events.*;
    import flash.net.*;
    import flash.utils.*;
    
    import com.bit101.components.*;
    public class FlashTest extends Sprite {
        
        private var fr:FileReference;
        private var l:Loader;
        private var sh:Shape;
        
        public function FlashTest() {
            loaderInfo.uncaughtErrorEvents.addEventListener(UncaughtErrorEvent.UNCAUGHT_ERROR, function (e:UncaughtErrorEvent):void { Wonderfl.log(e.error); });
            
            fr = new FileReference();
            new PushButton(stage, 0, 0, 'load', browse);
            fr.addEventListener(Event.SELECT, select);
            fr.addEventListener(Event.COMPLETE, frComplete);
            
            l = new Loader();
            l.contentLoaderInfo.addEventListener(Event.COMPLETE, lComplete);
            addChild(l);
            
            sh = new Shape();
            addChild(sh);
        }
        
        private function browse(e:MouseEvent):void {
            fr.browse([new FileFilter('Nine-Patch PNG (*.9.png)', '*.9.png')]);
        }
        
        private function select(e:Event):void {
            fr.load();
        }
        
        private function frComplete(e:Event):void {
            l.loadBytes(fr.data);
        }
        
        private function lComplete(e:Event):void {
            x = (stage.stageWidth - l.content.width * 2) >> 1;
            y = (stage.stageHeight - l.content.height * 2) >> 1;
            scaleX = 2;
            scaleY = 2;
            
            var ba:ByteArray = fr.data;
            ba.position = 8; // skip PNG header
            while (ba.bytesAvailable) {
                var length:uint = ba.readUnsignedInt();
                var type:uint = ba.readUnsignedInt();
                if (type == 0x6E705463) { // npTc
                    npTc(ba);
                    return;
                }
                ba.position += length;
                var crc:uint = ba.readUnsignedInt();
            }
        }
        
        private function npTc(ba:ByteArray):void {
            var wasDeserialized:int = ba.readByte();
            var numXDivs:int = ba.readByte();
            var numYDivs:int = ba.readByte();
            var numColors:int = ba.readByte();
            var _xDivs:uint = ba.readUnsignedInt();
            var _yDivs:uint = ba.readUnsignedInt();
            var paddingLeft:int = ba.readInt();
            var paddingRight:int = ba.readInt();
            var paddingTop:int = ba.readInt();
            var paddingBottom:int = ba.readInt();
            var _colors:uint = ba.readUnsignedInt();
            
            var xDivs:Vector.<int> = new Vector.<int>(numXDivs, true);
            var yDivs:Vector.<int> = new Vector.<int>(numYDivs, true);
            var colors:Vector.<uint> = new Vector.<uint>(numColors, true);
            
            var width:int = l.content.width;
            var height:int = l.content.height;
            var i:int;
            var stretchy:Boolean;
            var prev:int;
            var current:int;
            
            sh.graphics.clear();
            sh.graphics.beginFill(0x000000);
            
            for (i = 0, stretchy = false, prev = 0; i < numXDivs; i++, stretchy = !stretchy) {
                current = ba.readInt();
                xDivs[i] = current;
                if (stretchy) sh.graphics.drawRect(prev, -1, current - prev, 1);
                prev = current;
            }
            if (stretchy) sh.graphics.drawRect(prev, -1, width - prev, 1);
            
            for (i = 0, stretchy = false, prev = 0; i < numYDivs; i++, stretchy = !stretchy) {
                current = ba.readInt();
                yDivs[i] = current;
                if (stretchy) sh.graphics.drawRect(-1, prev, 1, current - prev);
                prev = current;
            }
            if (stretchy) sh.graphics.drawRect(-1, prev, 1, height - prev);
            
            sh.graphics.drawRect(paddingLeft, height, width - paddingLeft - paddingTop, 1);
            sh.graphics.drawRect(width, paddingTop, 1, height - paddingTop - paddingBottom);
            sh.graphics.endFill();
            
            for (i = 0; i < numColors; i++) {
                colors[i] = ba.readUnsignedInt();
            }
        }
        
    }
}
