/**
 * Copyright asuka616 ( http://wonderfl.net/user/asuka616 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/276o
 */

// forked from ShipNK's Fire Visualization
package {
    import flash.system.Security;
    import flash.display.Sprite;
    import flash.display.Shape;
    import flash.utils.ByteArray;
    import flash.events.Event;
    import flash.media.SoundChannel;
    import flash.media.SoundMixer;
    import flash.geom.Vector3D;
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    import flash.display.Sprite;
    import flash.filters.BlurFilter;
    import flash.geom.ColorTransform;
    import flash.events.MouseEvent;
    import flash.geom.Point;
    import flash.media.Sound;
    import flash.net.URLRequest;
    import flash.text.TextField;
    
    [SWF(frameRate=35, backgroundColor=0, width=500, height=500)]

    public class FlashTest extends Sprite {

        private var tf:TextField = new TextField();   
        private var bgm:Sound = new Sound();
        private var cooltime:int = 10;
        private var paper:BitmapData = new BitmapData( 500, 500, true, 0x00000000 );
        private var bit:Bitmap = new Bitmap( paper );
        private var sprite:Sprite = new Sprite();
        private var blur:BlurFilter = new BlurFilter( 16, 16, 3 );
        private var colorTransform:ColorTransform = new ColorTransform( 1, 1, 1, 0.9 );
        private var i:int = new int;
        private var center:Vector3D = new Vector3D( 250, 250, 50 );
        private var rotater:DotRotater = new DotRotater();
        private var rotationTemp:Vector3D = new Vector3D;
        private var shape:PolygonData = new PolygonData();
        private var shapeArray:Array = new Array;
        private var bgShape:Shape = new Shape();
        private var dataArray:Array = new Array;
        private var bytes:ByteArray = new ByteArray();
        private var soundPower:Number = new Number;
        
        public function FlashTest() {
            Security.loadPolicyFile( "http://joyfl.kr/shipworld/crossdomain.xml" );
            tf.text = "Loading...";
            tf.textColor = 0xffffff;bgm.load( new URLRequest( 'http://joyfl.kr/shipworld/sound/bgm.mp3' ) );
            bgm.addEventListener(Event.COMPLETE, completeEvent );
            this.addChild( bgShape );
            this.addChild( bit );
            this.addChild( tf );
            stage.addEventListener( Event.ENTER_FRAME, process );
        }
        
        private function completeEvent ( e:Event ) :void
        {
            bgm.play( 0, 100000 );
            tf.text = "Complete...";
        }
        
        
        
        private function process ( e:Event ) :void
        {
             SoundMixer.computeSpectrum( bytes, true, 0 );
             soundPower = bytes.readFloat();
             //
             bgShape.graphics.clear();
             bgShape.graphics.beginFill( 0x000000, soundPower / 4 );
             bgShape.graphics.drawRect( -10, -10, 510, 510 );
             bgShape.graphics.endFill();
             //
             for( i = 0; i < soundPower * 3; ++ i )
             {
              shape = new PolygonData();
              shape.graphics.lineStyle( bytes.readFloat() * 7, 0xff0000 + Random( 10001 ) );
              shape.graphics.beginFill( 0xff0000 + Random( 5001 ), 0.8 );
              shape.drawPolygon( int( bytes.readFloat() * 4 ) + 3, bytes.readFloat() * 40 );
              shape.x = center.x + Random( 6 ) - 2.5;
              shape.y = center.y;
              shape.z = center.z + Random( 6 ) - 2.5;
              shape.alpha = bytes.readFloat();
              shape.rotation = Random( 360 );
              sprite.addChild( shape );
              shapeArray.push( shape );
              dataArray.push( { speed:bytes.readFloat() * 2, myLength:0, myAngle:0, rotation:Random( 360 ), rotationSpeed:bytes.readFloat() * 40, speedY:Random( 19 ) - 9 } );
             }
             //
             for( i = 0; i < shapeArray.length; ++ i )
             {
              if( shapeArray[ i ].alpha > 0 )
              {
               dataArray[ i ].myLength += 2;
               dataArray[ i ].rotation += dataArray[ i ].rotationSpeed;
               dataArray[ i ].speed *= 0.6;
               dataArray[ i ].rotationSpeed *= 0.9;
               shapeArray[ i ].y += dataArray[ i ].speedY;
               shapeArray[ i ].alpha -= 0.02;
               shapeArray[ i ].scaleX -= 0.05 * Random( 3 );
               shapeArray[ i ].scaleY -= 0.05 * Random( 3 );
               
               if( soundPower >= 0.4 )
               {
                shapeArray[ i ].x += Random( 6 ) - 2.5;
                shapeArray[ i ].y += Random( 6 ) - 2.5;
                shapeArray[ i ].z += Random( -6 );
               }
               
               center.x += ( 250 - center.x ) * 0.3;
               center.y += ( 250 - center.y ) * 0.3;
               center.z += ( -50 - center.z ) * 0.3;
               
               if( soundPower > 1 )
               {
                center.x = Random( 550 )
                center.y = Random( 400 )
                center.z = Random( -100 )
             }
               
               dataArray[ i ].myAngle = Math.atan2( shapeArray[ i ].z - center.z, shapeArray[ i ].x - center.x );
               dataArray[ i ].myLength = Math.sqrt( ( shapeArray[ i ].x - center.x ) * ( shapeArray[ i ].x - center.x ) + ( shapeArray[ i ].z - center.z ) * ( shapeArray[ i ].z - center.z ) );
               shapeArray[ i ].z += Math.sin( dataArray[ i ].myAngle ) * dataArray[ i ].myLength * dataArray[ i ].speed;
               shapeArray[ i ].x += Math.cos( dataArray[ i ].myAngle ) * dataArray[ i ].myLength * dataArray[ i ].speed;
               
               rotationTemp = rotater.rotateY( center, new Vector3D( shapeArray[ i ].x, shapeArray[ i ].y, shapeArray[ i ].z ), dataArray[ i ].rotation * Math.PI / 180 );
               shapeArray[ i ].x = rotationTemp.x;
               shapeArray[ i ].z = rotationTemp.z;
              }
              else
              {
               sprite.removeChild( shapeArray[ i ] );
               shapeArray.splice( i, 1 );
               dataArray.splice( i, 1 );
               i -= 1;
              }
             }
             
             paper.draw( sprite );
             paper.applyFilter( paper, paper.rect, new Point, blur );
             paper.colorTransform( paper.rect, colorTransform );
        }
        private function Random ( n:Number ) :int
        {
         return int( n * Math.random() );
        } 
    }
}



import flash.display.Shape;
import flash.geom.*;
    
class PolygonData extends Shape
{
   private var i:int = new int;
   public function drawPolygon( edgeNum:int, radius:Number ) :void
   {
       with( this.graphics )
       {
           moveTo( 0, radius );
           for( i = 1; i < edgeNum + 1; ++ i )
           {
               lineTo( Math.sin( ( i * 360 / edgeNum ) * Math.PI / 180 ) * radius, Math.cos( ( i * 360 / edgeNum ) * Math.PI / 180 ) * radius );
           }
       }
   }
}
    

class DotRotater
{
    public var resultData:Vector3D;
    public var centerData:Vector3D;
    public var objectData:Vector3D;
    public var circleLength:Array;
    public var circleAngle:Array;
    
    public function DotRotater()
    {
        this.circleLength = new Array();
        this.circleAngle = new Array();
    }// end function

    public function rotateX(param1:Vector3D, param2:Vector3D, param3:Number) : Vector3D
    {
        this.centerData = new Vector3D(param1.x, param1.y, param1.z);
        this.objectData = new Vector3D(param2.x, param2.y, param2.z);
        this.resultData = new Vector3D(param2.x, param2.y, param2.z);
        this.circleLength[0] = Vector3D.distance(this.centerData, this.objectData);
        this.circleLength[1] = Math.sqrt((this.centerData.x - this.objectData.x) * (this.centerData.x - this.objectData.x) + (this.centerData.y - this.objectData.y) * (this.centerData.y - this.objectData.y));
        this.circleLength[2] = Math.sqrt((this.centerData.y - this.objectData.y) * (this.centerData.y - this.objectData.y) + (this.centerData.z - this.objectData.z) * (this.centerData.z - this.objectData.z));
        this.circleLength[3] = Math.sqrt((this.centerData.x - this.objectData.x) * (this.centerData.x - this.objectData.x) + (this.centerData.z - this.objectData.z) * (this.centerData.z - this.objectData.z));
        this.circleAngle[1] = Math.atan2(this.centerData.y - this.objectData.y, this.centerData.x - this.objectData.x) * -180 / Math.PI + 180;
        this.circleAngle[2] = Math.atan2(this.centerData.y - this.objectData.y, this.centerData.z - this.objectData.z) * -180 / Math.PI + 180;
        this.circleAngle[3] = Math.atan2(this.centerData.z - this.objectData.z, this.centerData.x - this.objectData.x) * 180 / Math.PI + 180;
        this.resultData.y = Math.sin((this.circleAngle[2] - param3 % 360) * Math.PI / 180) * -1 * this.circleLength[2] + this.centerData.y;
        this.resultData.z = Math.cos((this.circleAngle[2] - param3 % 360) * Math.PI / 180) * this.circleLength[2] + this.centerData.z;
        return this.resultData;
    }// end function

    public function rotateY(param1:Vector3D, param2:Vector3D, param3:Number) : Vector3D
    {
        this.centerData = new Vector3D(param1.x, param1.y, param1.z);
        this.objectData = new Vector3D(param2.x, param2.y, param2.z);
        this.resultData = new Vector3D(param2.x, param2.y, param2.z);
        this.circleLength[0] = Vector3D.distance(this.centerData, this.objectData);
        this.circleLength[1] = Math.sqrt((this.centerData.x - this.objectData.x) * (this.centerData.x - this.objectData.x) + (this.centerData.y - this.objectData.y) * (this.centerData.y - this.objectData.y));
        this.circleLength[2] = Math.sqrt((this.centerData.y - this.objectData.y) * (this.centerData.y - this.objectData.y) + (this.centerData.z - this.objectData.z) * (this.centerData.z - this.objectData.z));
        this.circleLength[3] = Math.sqrt((this.centerData.x - this.objectData.x) * (this.centerData.x - this.objectData.x) + (this.centerData.z - this.objectData.z) * (this.centerData.z - this.objectData.z));
        this.circleAngle[1] = Math.atan2(this.centerData.y - this.objectData.y, this.centerData.x - this.objectData.x) * -180 / Math.PI + 180;
        this.circleAngle[2] = Math.atan2(this.centerData.y - this.objectData.y, this.centerData.z - this.objectData.z) * -180 / Math.PI + 180;
        this.circleAngle[3] = Math.atan2(this.centerData.z - this.objectData.z, this.centerData.x - this.objectData.x) * 180 / Math.PI + 180;
        this.resultData.x = Math.cos((this.circleAngle[3] - param3 % 360) * Math.PI / 180) * this.circleLength[3] + this.centerData.x;
        this.resultData.z = Math.sin((this.circleAngle[3] - param3 % 360) * Math.PI / 180) * this.circleLength[3] + this.centerData.z;
        return this.resultData;
    }// end function

    public function rotateZ(param1:Vector3D, param2:Vector3D, param3:Number) : Vector3D
   {
        this.centerData = new Vector3D(param1.x, param1.y, param1.z);
        this.objectData = new Vector3D(param2.x, param2.y, param2.z);
        this.resultData = new Vector3D(param2.x, param2.y, param2.z);
        this.circleLength[0] = Vector3D.distance(this.centerData, this.objectData);
        this.circleLength[1] = Math.sqrt((this.centerData.x - this.objectData.x) * (this.centerData.x - this.objectData.x) + (this.centerData.y - this.objectData.y) * (this.centerData.y - this.objectData.y));
        this.circleLength[2] = Math.sqrt((this.centerData.y - this.objectData.y) * (this.centerData.y - this.objectData.y) + (this.centerData.z - this.objectData.z) * (this.centerData.z - this.objectData.z));
        this.circleLength[3] = Math.sqrt((this.centerData.x - this.objectData.x) * (this.centerData.x - this.objectData.x) + (this.centerData.z - this.objectData.z) * (this.centerData.z - this.objectData.z));
        this.circleAngle[1] = Math.atan2(this.centerData.y - this.objectData.y, this.centerData.x - this.objectData.x) * -180 / Math.PI + 180;
        this.circleAngle[2] = Math.atan2(this.centerData.y - this.objectData.y, this.centerData.z - this.objectData.z) * -180 / Math.PI + 180;
        this.circleAngle[3] = Math.atan2(this.centerData.z - this.objectData.z, this.centerData.x - this.objectData.x) * 180 / Math.PI + 180;
        this.resultData.x = Math.cos((this.circleAngle[1] - param3 % 360) * Math.PI / 180) * this.circleLength[1] + this.centerData.x;
        this.resultData.y = Math.sin((this.circleAngle[1] - param3 % 360) * Math.PI / 180) * -1 * this.circleLength[1] + this.centerData.y;
        return this.resultData;
    }// end function
}
