/**
 * Copyright ushisantoasobu ( http://wonderfl.net/user/ushisantoasobu )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/26nL
 */

package {
    import flash.display.Sprite;
    import flash.display.Loader;
    import flash.display.MovieClip;    
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.events.TimerEvent;
    import flash.geom.Point;
    import flash.utils.Timer;
    import flash.net.URLRequest;
    
    public class FlashTest extends Sprite {
        
        public var floorObj:Sprite;
        public var obj:Array;
        public var maskObj:Array;
        public var clickedNum:int = -1;
        public var angle:Number = 0;
        public var timer:Timer;
        public var hankei:Number = 160;
        
        public function FlashTest() {
            obj = new Array();
            maskObj = new Array();
            
            for(var num:Number = 0; num < 12; num++){
                obj.push(new Sprite());
                //var num:Number = obj.length - 1;
                this.addChild(obj[num]);                
                maskObj.push(new Sprite());
                obj[num].buttonMode = true;
                obj[num].useHandCursor = true;
                
                obj[num].name = String(num);
                obj[num].x = this.stage.stageWidth / 2;
                obj[num].y = this.stage.stageHeight / 2;
                obj[num].scaleX = 0;
                obj[num].scaleY = 0;
                obj[num].addEventListener(MouseEvent.CLICK, onClick);
                obj[num].mask = maskObj[num];
                obj[num].addChild(maskObj[num]);
                
                var imgLoader:Loader = new Loader();
                obj[num].addChild(imgLoader);
                obj[num].mouseChildren = false;
                
                var urlReq:URLRequest = new URLRequest("http://moguramogura.site90.com/sbcr/img"+num+".jpg");
                imgLoader.contentLoaderInfo.addEventListener(Event.COMPLETE, onImageLoaded);
                imgLoader.load(urlReq);                                              
            }
            
            floorObj = new Sprite();
            floorObj.graphics.clear();
            floorObj.graphics.lineStyle(0, 0, 0);
            floorObj.graphics.beginFill(0xFF0000);
            floorObj.graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
            floorObj.graphics.endFill();
            floorObj.alpha = 0;
            
            floorObj.addEventListener(MouseEvent.CLICK, onFloorClick);
            this.addChildAt(floorObj, 0);
            
            timer = new Timer(33);
            timer.addEventListener(TimerEvent.TIMER, loop);
            timer.start();
            
        }
        
        private function onImageLoaded(e:Event):void{
            e.target.loader.x = e.target.loader.width / (-2);
            e.target.loader.y = e.target.loader.height / (-2);
            var num:int = int(e.target.loader.parent.name);
            maskObj[num].graphics.clear;
            maskObj[num].graphics.lineStyle(0, 0, 0);
            maskObj[num].graphics.beginFill(0xFF0000);
            maskObj[num].graphics.drawCircle(0, 0, Math.min(e.target.loader.width/2, e.target.loader.height/2));
            maskObj[num].graphics.endFill();
        }
        
        private function onClick(e:MouseEvent):void{
            if(clickedNum == int(e.target.name)){
                clickedNum = -1;
            }else{
                clickedNum = int(e.target.name);
            }
        }

        private function onFloorClick(e:MouseEvent):void{
            clickedNum = -1;
        }
        
        private function loop(e:TimerEvent):void{
            angle += 0.01;
            
            for(var i:int = 0; i < obj.length; i++){
                var ichi:Point = new Point();
                var ookisa:Number;
                
                if(clickedNum == i){
                    ichi.x = stage.stageWidth / 2;
                    ichi.y = stage.stageHeight / 2;
                    ookisa = 0.7;
                }else{
                    ichi.x = stage.stageWidth / 2 + hankei*Math.cos(angle + i / obj.length * Math.PI * 2);
                    ichi.y = stage.stageHeight / 2 + hankei*Math.sin(angle + i / obj.length * Math.PI * 2);
                    ookisa = 0.3;
                }
                obj[i].x += (ichi.x - obj[i].x) / 3;
                obj[i].y += (ichi.y - obj[i].y) / 3;
                obj[i].scaleX += (ookisa - obj[i].scaleX) / 10;
                obj[i].scaleY += (ookisa - obj[i].scaleY) / 10;
            }

        }


        
    }
}