/**
 * Copyright littlepad ( http://wonderfl.net/user/littlepad )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/26d4
 */

package {
    import flash.display.Sprite;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.PixelSnapping;
    import flash.display.BlendMode;
    import flash.geom.ColorTransform;
    import flash.events.TimerEvent;
    import flash.utils.Timer;
    import flash.geom.Rectangle;
    import flash.geom.Point;
    import flash.filters.BlurFilter;
    import flash.geom.Matrix;
    import flash.events.Event;
    import flash.geom.Point;
  
    public class FlashTest extends Sprite {
        private const WIDTH:Number = 456;
        private const HEIGHT:Number = 456;
        
        private var _canvas:BitmapData;
        private var _glow:BitmapData;
        private var _cTra:ColorTransform;
        private var _rect:Rectangle;
        private var _particles:Array;
        private var _cPoint:Point;
        
        public function FlashTest() {
            init();
        }
        
        private function init():void {
            _rect = new Rectangle(0, 0, WIDTH, HEIGHT);
            _cTra = new ColorTransform(.8, .8, .9, 1);
            _particles = new Array();
            _cPoint = new Point(WIDTH/2, HEIGHT/2);
            
            _canvas = new BitmapData(WIDTH, HEIGHT, false, 0xFF000000);
            addChild(new Bitmap(_canvas));
            
            _glow = new BitmapData(WIDTH/4, HEIGHT/4, false, 0xFF000000);
            var bmp:Bitmap = new Bitmap(_glow, PixelSnapping.NEVER, true);
            bmp.scaleX = bmp.scaleY = 4;
            bmp.blendMode = BlendMode.ADD;
            addChild(bmp);
            
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
            
            var timer:Timer = new Timer(100);
            timer.addEventListener(TimerEvent.TIMER, onTimer);
            timer.start();
        }
        
        private function onEnterFrame(e:Event):void {
            _canvas.applyFilter(_canvas, _rect, new Point(), new BlurFilter(1, 1));
            _canvas.colorTransform(_rect, _cTra);
            
            for(var i:uint = 0; i < _particles.length; i++){
                var p:Particle = _particles[i];
                var radian:Number = Math.atan2( _cPoint.y - p.y, _cPoint.x - p.x );  
                p.vx += 10 * Math.cos(radian);
                //p.vx += 0.2 * Math.cos(radian);
                p.vy += 0.2 * Math.sin(radian);
                p.vx *= 0.9;
                p.vy *= 0.9;
                p.x += p.vx;
                p.y += p.vy;
                
                _canvas.setPixel32(p.x, p.y, p.c);
                
                if(Math.abs(p.x - _cPoint.x) < 0.1 || Math.abs(p.y - _cPoint.y) < 0.1) {
                    _particles.splice(i, 1);
                }
            }
            _glow.draw(_canvas, new Matrix(1/4, 0, 0, 1/4));
        }
        
        private function onTimer(e:TimerEvent):void {
            var n:uint = 50;
            while(n--) {
                var p:Particle = new Particle();
                p.x = WIDTH * Math.random();
                p.y = HEIGHT * Math.random();
                //p.c = 0xFFFFFFFF * Math.random();
                _particles.push(p);
            }
        }
    }
}

internal class Particle {
    public var x:Number;
    public var y:Number;
    public var vx:Number;
    public var vy:Number;
    public var c:Number;
    public function Particle() {
        x = 0;
        y = 0;
        vx = 0;
        vy = 0;
        c = 0xFFFFFFFF;
    }
}