/**
 * Copyright tepe ( http://wonderfl.net/user/tepe )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/26bK
 */

// forked from q.kensuke's forked from: forked from: Sound Visualizer #02
// forked from hacker_ns7ubky2's forked from: Sound Visualizer #02
// forked from hycro's Sound Visualizer #02
package
{
    //----------------------------------
    // Music by "SHW"(http://shw.in/)
    //----------------------------------
    
    import flash.display.*;
    import flash.events.*;
    import flash.filters.BlurFilter;
    import flash.geom.*;
    import flash.media.*;
    import flash.net.*;
    import flash.utils.*;
    import flash.text.*;
    import frocessing.display.F5MovieClip2DBmp;
    
    [SWF(width="465", height="465", frameRate="60")]
    public class SoundVisualizer2 extends F5MovieClip2DBmp
    {
        private static const POLICY_FILE:String = "http://hycro.crz.jp/crossdomain.xml";
        private static const SOUND_FILE:String = "http://hycro.crz.jp/wonderfl/sound/tsudumi-japan2.mp3";
        //private static var SOUND_FILE:String = "http://www.takasumi-nagai.com/soundfiles/sound001.mp3";
        
        private const Radius:uint = 100;
        
        private var _sound:Sound;
        private var _channel:SoundChannel;
        
        //private var _circle:Circle;
        private var _count:uint = 0;
        
        /**
         * コンストラクタ
         * 
         */
        public function SoundVisualizer2()
        {
            //_circle = new Circle(0, 128);
            _sound = new Sound();
            
            _sound.load(new URLRequest(SOUND_FILE), new SoundLoaderContext(5000, true));
            _sound.addEventListener(ProgressEvent.PROGRESS, onProgress);
            _sound.addEventListener(Event.COMPLETE, onLoadComplete);
        }
        
        /**
         * 描画関連の初期化
         * 
         */
        public function setup():void {
            size(stage.stageWidth, stage.stageHeight);
            background(0x0);
            stroke(255, .3000);
            noFill();
        }
        
        /**
         * 音楽ファイルロード中の処理
         * 
         */
        private function onProgress(evt:ProgressEvent):void {
            //_circle.radius = Radius * evt.bytesLoaded / evt.bytesTotal;
        }
        
        /**
         * 音楽ファイルロード完了
         * 
         */
        private function onLoadComplete(evt:Event):void {
            _channel = _sound.play(0, int.MAX_VALUE);
            //_circle.radius = Radius;
            addChild(s2);
            addChild(tf1);
            tf1.textColor = 0xffffff;
            s2.x = 230;
            s2.y = 230;
            
        }
        
        /**
         * 頂点データの更新
         * 
         */
         private var rad:Number;
         private var cntL:int=0;
         private var leftVol:Number=0;
         private var rightVol:Number=0;
         private var s2:Sprite = new Sprite();
         private var tf1:TextField = new TextField();
         private var beatCnt:int = 0;
        private function updateCircle():void {
            var data:ByteArray = new ByteArray();
            SoundMixer.computeSpectrum(data, true);
            
            s2.graphics.clear();
            s2.graphics.beginFill(0x0000ff,0.5);
            s2.graphics.drawCircle(0,0,leftVol*126);
            s2.graphics.endFill();
            s2.graphics.beginFill(0x00ffff,0.2);
            s2.graphics.drawCircle(0,0,rightVol*126);
            s2.graphics.endFill();
            
            if(leftVol*1.5 < _channel.leftPeak){
                //leftVol = _channel.leftPeak;
                if(0<cntL && leftVol*1.2<_channel.leftPeak && 0.2<_channel.leftPeak){
                    beatCnt++;
                    tf1.text = beatCnt.toString();
                    
                    s2.graphics.beginFill(0xffffff);
                    //s2.graphics.drawRect(-255,0,460,50);
                    s2.graphics.drawCircle(200,0,20);
                    s2.graphics.endFill();
                    cntL=0;
                }
                leftVol = _channel.leftPeak;
                cntL=0;

            }
            else{ 
                cntL++;
                leftVol /= 1.05;
            }
            
            if(rightVol < _channel.rightPeak){ 
                rightVol = _channel.rightPeak;
            }
            else rightVol /= 1.05;
            
            
        }
        
        public function draw():void {
            if (_channel) {
                updateCircle();
            }
        }
    }
}