/**
 * Copyright ton ( http://wonderfl.net/user/ton )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/26Hw
 */

package {
    import caurina.transitions.Tweener;
    import com.bit101.components.Label;
    import com.bit101.components.Panel;
    import com.bit101.components.PushButton;
    import com.bit101.components.RadioButton;
    import flash.display.DisplayObject;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.events.TimerEvent;
    import flash.geom.Point;
    import flash.net.navigateToURL;
    import flash.net.URLRequest;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    import flash.text.TextFieldType;
    import flash.utils.getQualifiedClassName;
    import flash.utils.getTimer;
    import flash.utils.Timer;
    
    /**
     * 利きトゥイーンテスト
     * @author ton
     */
    public class Main extends Sprite {
        private var startPoint:Point;
        private var endPoint:Point;
        private var tweenMC:Sprite;
        private var transitions:Array;
        
        private var messageTF:TextField;
        
        private var panel:Panel;
        private var radioButtons:Array;
        
        private var correctTransition:String;
        
        private var stageLabel:Label;
        private var totalStages:int = 10;
        private var currentStages:int = 0;
        
        private var correctNum:int = 0;
        
        private var startTime:int;
        private var messageTime:int = 2;
        
        public function Main():void {
            startPoint = new Point(100, 100);
            endPoint = new Point(stage.stageWidth - 100, 100);
            
            tweenMC = new Sprite();
            tweenMC.graphics.beginFill(0x507ea4);
            tweenMC.graphics.drawRoundRect(0, 0, 20, 20, 10);
            tweenMC.graphics.endFill();
            
            transitions = ["linear", "easeInSine", "easeOutSine", "easeInOutSine", "easeOutInSine", "easeInCubic", "easeOutCubic", "easeInOutCubic", "easeOutInCubic", "easeInQuint", "easeOutQuint", "easeInOutQuint", "easeOutInQuint", "easeInCirc", "easeOutCirc", "easeInOutCirc", "easeOutInCirc", "easeInBack", "easeOutBack", "easeInOutBack", "easeOutInBack", "easeInQuad", "easeOutQuad", "easeInOutQuad", "easeOutInQuad", "easeInQuart", "easeOutQuart", "easeInOutQuart", "easeOutInQuart", "easeInExpo", "easeOutExpo", "easeInOutExpo", "easeOutInExpo", "easeInElastic", "easeOutElastic", "easeInOutElastic", "easeOutInElastic", "easeInBounce", "easeOutBounce", "easeInOutBounce", "easeOutInBounce"];
            
            messageTF = new TextField();
            messageTF.text = "what type of tween?\nclick to start";
            messageTF.autoSize = "center";
            alignmentToCenter(messageTF);
            addChild(messageTF);
            
            panel = new Panel(this);
            removeChild(panel);
            stageLabel = new Label(panel);
            alignmentToCenter(panel);
            radioButtons = [];
            for (var i:int = 1; i <= 4; i++) {
                var radio:RadioButton = new RadioButton(panel, 0, i * 20, "", false, clickRadioButtonHandler);
                radioButtons.push(radio);
            }
            
            stage.addEventListener(MouseEvent.CLICK, startTimerHandler);
        }
        
        private function alignmentToCenter(mc:DisplayObject):void {
            mc.x = (stage.stageWidth - mc.width) / 2;
            mc.y = (stage.stageHeight - mc.height) / 2;
        }
        
        private function startTimerHandler(e:MouseEvent):void {
            stage.removeEventListener(MouseEvent.CLICK, startTimerHandler);
            
            messageTF.text = "3";
            
            var countDownTimer:Timer = new Timer(1000, 3);
            countDownTimer.addEventListener(TimerEvent.TIMER, tickHandler);
            countDownTimer.addEventListener(TimerEvent.TIMER_COMPLETE, completeTimerHandler);
            countDownTimer.start();
        }
        
        private function tickHandler(e:TimerEvent):void {
            var timer:Timer = e.currentTarget as Timer;
            messageTF.text = String(3 - timer.currentCount);
        }
        
        private function completeTimerHandler(e:TimerEvent):void {
            var timer:Timer = e.currentTarget as Timer;
            timer.removeEventListener(TimerEvent.TIMER, tickHandler);
            timer.removeEventListener(TimerEvent.TIMER_COMPLETE, completeTimerHandler);
            
            removeChild(messageTF);
            
            startGame();
        }
        
        private function startGame():void {
            startTime = getTimer();
            addChild(tweenMC);
            next();
        }
        
        private function next():void {
            correctTransition = getRandomTransition();
            var questions:Array = [];
            questions.push(correctTransition);
            
            for (var i:int = 0; i < 3; i++) {
                var t:String;
                
                do {
                    t = getRandomTransition();
                } while (questions.indexOf(t) != -1);
                
                questions.push(t);
            }
            
            for (i = 0; i < 4; i++) {
                var radio:RadioButton = radioButtons[i];
                var index:int = Math.random() * questions.length;
                var q:String = questions[index];
                questions.splice(index, 1);
                radio.label = q;
                radio.selected = false;
            }
            stageLabel.text = (currentStages + 1) + "/" + totalStages;
            addChild(panel);
            tweenWithTransition(correctTransition);
        }
        
        private function tweenWithTransition(transition:String):void {
            if (Tweener.isTweening(tweenMC)) {
                Tweener.removeTweens(tweenMC);
            }
            
            tweenMC.x = startPoint.x;
            tweenMC.y = startPoint.y;
            Tweener.addTween(tweenMC, {x: endPoint.x, y: endPoint.y, time: 2, delay: 0.5, transition: transition, onComplete: function():void {
                    tweenWithTransition(transition);
                }});
        }
        
        private function getRandomTransition():String {
            return transitions[int(Math.random() * transitions.length)];
        }
        
        private function clickRadioButtonHandler(e:MouseEvent):void {
            removeChild(panel);
            addChild(messageTF);
            
            var radio:RadioButton = e.currentTarget as RadioButton;
            
            if (radio.label == correctTransition) {
                correctNum++;
                messageTF.text = "correct!";
            } else {
                messageTF.text = "wrong...\nresult is " + correctTransition;
            }
            
            currentStages++;
            
            Tweener.addTween(this, {time: messageTime, onComplete: function():void {
                    removeChild(messageTF);
                    
                    if (currentStages >= totalStages) {
                        finish();
                    } else {
                        next();
                    }
                }});
        }
        
        private function finish():void {
            var time:int = getTimer() - startTime;
            time -= totalStages * messageTime * 1000;
            messageTF.text = "result\n" + "correct : " + correctNum + "/" + totalStages + "\n" + "time : " + time / 1000 + "sec";
            addChild(messageTF);
            
            var tweetButton:PushButton = new PushButton(this, 0, 0, "Tweet", function(e:MouseEvent):void {
                    navigateToURL(new URLRequest("https://twitter.com/intent/tweet?source=webclient&text=what%20type%20of%20tween%20?  correct : " + correctNum + "/" + totalStages + " time : " + time / 1000 + "sec" + "  http://wonderfl.net/c/26Hw %23wonderfl"));
                });
            alignmentToCenter(tweetButton);
            tweetButton.y += 100;
        }
    }
}