/**
 * Copyright s8t1h12akj ( http://wonderfl.net/user/s8t1h12akj )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/26Ce
 */

// forked from makc3d's ff[2]: spectrum - spiral
// forked from Robbie.Maglone's forked from: spectrum - spiral
// forked from k__'s spectrum - spiral
/*
this code is originally written to be used as a music visualizer used with Sound.computeSpectrum()
and now let's make this thing work with peaks /makc
*/

package {
    import flash.display.*;
    import flash.events.*;
    import flash.text.*;
    import flash.geom.*;
    import flash.filters.*;
    import flash.media.*;
    import flash.net.*;
    
    public class Main extends Sprite{
        private var canvas:BitmapData;
        private var canvasRect:Rectangle;
        private var oPt:Point;
        private var cMtx:ColorMatrixFilter;
        private var blur:BlurFilter;
        private var shape:Shape;
        private var cx:Number,cy:Number;
        private var verts:Vector.<Number>;
        private var pVerts:Vector.<Number>;
        private var uvts:Vector.<Number>;
        private var pmtx:Matrix3D;
        private var pers:PerspectiveProjection;
        private var angles:Vector.<Number>;
        private var vPos:Vector.<Number>;
        private var levs:Vector.<Number>;
        private var xr:Number = 0, yr:Number = 0;
        private var cnt:uint = 0;
        private var waves:Array;
        private var numWaves:uint = 5;
        private const WAVE_HEIGHT:Number = 50;
        private const BASE_RADIUS:Number = 80;
        
        private var peaks:Array, channel:SoundChannel;
        
        
        public function Main() {
            peaks = new Array (256);
            for (i = 0; i < 256; i++) peaks[i] = 0;

            var sound:Sound = new Sound(new URLRequest("https://api.audiotool.com/track/megadestroyer/play.mp3"));
            channel = sound.play(0, int.MAX_VALUE);

            angles = new Vector.<Number>();
            vPos = new Vector.<Number>();
            levs = new Vector.<Number>();
            var n:Number = 0;
            var freq:Number;
            for (var i:uint = 0; i < 2000; i ++) {
                freq = 55 * Math.pow(2, i/120);
                if (freq > n * 14080/163.5) {
                    angles.push(Math.PI * 2  * i / 120); 
                    vPos.push(-(angles[n] * 6 - 265));
                    n ++;
                }
                if (n >= 256) {
                    break;
                }
            }
            for (i = 0; i < 256; i ++) {
                levs.push(0);
            }
            
            shape = new Shape();
            addChild(new Bitmap(canvas = new BitmapData(stage.stageWidth,stage.stageHeight,true,0xff000000)));
            canvasRect = canvas.rect;
            oPt = new Point(0,0);
            cMtx = new ColorMatrixFilter(
                                           [0.99,0,0,0,0,
                                            0,0.99,0,0,0,
                                            0,0,0.99,0,0,
                                            0,0,0,1,0]
                                           );
            blur = new BlurFilter(2,2);
            cx = stage.stageWidth / 2;
            cy = stage.stageHeight / 2;
            pVerts = new Vector.<Number>();
            pmtx = new Matrix3D();
            pers = new PerspectiveProjection();
             uvts = new Vector.<Number>();
            addEventListener(Event.ENTER_FRAME, h_enterFrame);
            
            initWaves();
        }
        
        private function initWaves():void {
            waves = new Array();
            for (var i:uint = 0; i < numWaves; i ++) {
                waves.push(Math.random());
            }
        }
        
        private function h_enterFrame(evt:Event):void {
            peaks.pop();
            peaks.unshift (Math.sqrt (channel.leftPeak + channel.rightPeak));

            var i:uint,j:uint;
            var lev:Number;
            verts = new Vector.<Number>;
            if (Math.random() < 0.01) {
                initWaves();
            }
            for (i = 0; i < 256; i ++) {
                lev = peaks[i];

                if (!levs[i]) {
                    levs[i] = 0;
                }
                if (lev > levs[i]) {
                    levs[i] = (lev + levs[i]) / 2;
                } else {
                    levs[i] *= 0.9;
                }
                verts.push(Math.cos(angles[i]) * (levs[i] * WAVE_HEIGHT + BASE_RADIUS));
                verts.push(vPos[i]);
                verts.push(Math.sin(angles[i]) * (levs[i] * WAVE_HEIGHT + BASE_RADIUS));
            }
            
            // graphics replesentation
            var gr:Graphics = shape.graphics;
            gr.clear();
            
            pers.fieldOfView = 100;
            pmtx.identity();
            yr -= Math.sin(cnt / 200);
            xr += 0.5;
            pmtx.appendRotation(xr, Vector3D.X_AXIS);
            pmtx.appendRotation(yr, Vector3D.Y_AXIS);
            pmtx.appendTranslation(0, 0, pers.focalLength);
            pmtx.append(pers.toMatrix3D());
            bugfix(pmtx);
            Utils3D.projectVectors(pmtx, verts, pVerts, uvts);
            cnt = (cnt + 1) % (256 * 10);
            for (i = 20; i < 254; i ++) {
                var r:uint = (cnt + i) % 256;
                var g:uint = (cnt + i + 12) % 256;
                var b:uint = (cnt+ i + 32) % 256;
                gr.lineStyle(0,r << 16 | g << 8 | b);
                if (i == 20) {
                    gr.moveTo(pVerts[i * 2] + cx, pVerts[i * 2 + 1] + cy);
                } else {
                    gr.curveTo(pVerts[i * 2] + cx, pVerts[i * 2 + 1] + cy, 
                            (pVerts[i * 2] + pVerts[i * 2 + 2]) / 2 + cx, (pVerts[i * 2 + 1] + pVerts[i * 2 + 3]) / 2 + cy);
                }
            }
            canvas.draw(shape, null, null, BlendMode.ADD);
            canvas.applyFilter(canvas,canvasRect,oPt,cMtx);
            canvas.applyFilter(canvas,canvasRect,oPt,blur);
        }
        
          private function bugfix(matrix:Matrix3D):void {
             var m1:Matrix3D = new Matrix3D(Vector.<Number>([ 0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 1, 0 ]));
            var m2:Matrix3D = new Matrix3D(Vector.<Number>([ 0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 1,  0, 0, 0, 0 ]));
            m1.append(m2);
            if (m1.rawData[15] == 20) {
                var rawData:Vector.<Number> = matrix.rawData;
                rawData[15] /= 20;
                matrix.rawData = rawData;
            }
          }
    }
}
