/**
 * Copyright Akiyah ( http://wonderfl.net/user/Akiyah )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/253b
 */

package {
    import flash.display.*;
    import flash.events.*;
    import flash.text.*;
    import flash.filters.*;
    import flash.system.*;
    import org.papervision3d.core.effects.view.*;
    import org.papervision3d.core.proto.*;
    import org.papervision3d.materials.*;
    import org.papervision3d.materials.special.*;
    import org.papervision3d.materials.utils.*;
    import org.papervision3d.objects.*;
    import org.papervision3d.objects.primitives.*;
    import org.papervision3d.scenes.*;
    import caurina.transitions.*;

    public class PresenCube extends ReflectionView {
        Security.loadPolicyFile("http://assets.wonderfl.net/crossdomain.xml");
        public static const IMAGE_URL:String = "http://assets.wonderfl.net/images/related_images/";
        public static const BOARD_URL:String     = "9/98/988f/988fbf68a17439f1ebbab31b933a57625bcd82cb"

        public function PresenCube() {
            surfaceHeight = -100;
            viewportReflection.filters = [new BlurFilter()];

            var param:Object = new Object();
            param.top   = "うらしま\nたろう";
            param.back  = "むかし\nむかし\nうらしまは";
            param.right = "たすけた\nかめに\nつれられて";
            param.front = "りゅぐうじょうへ\nきてみれば";
            param.left  = "えにも\nかけない\nうつくしさ";
            scene.addChild(createCube(param));
            
            addEventListener(Event.ENTER_FRAME, update);
        }

        public function update(e:Event):void {
            var c:Number = (2/3 - (mouseX / stage.width)) * (Math.PI * 3 / 2); // 180 - -90
            var d:Number = (1 - (mouseY / stage.height)) * (Math.PI / 2); // 0 - 90
            camera.x = Math.sin(c) * Math.cos(d) * 300;
            camera.z = Math.cos(c) * Math.cos(d) * 300;
            camera.y = Math.sin(d) * 300;
            singleRender();
        }

        public function createCube(param:Object):Cube {
            var mlist:MaterialsList = new MaterialsList();
            mlist.addMaterial(createMaterial(""), "all");
            for(var key: String in param){
                mlist.addMaterial(createMaterial(param[key]), key);
            }
            return new Cube(mlist, 150, 150, 100, 4, 4, 4);
        }

        private function createMaterial(text:String):MaterialObject3D {
            var material:CompositeMaterial = new CompositeMaterial();
            material.addMaterial(new BitmapFileMaterial(IMAGE_URL + BOARD_URL ));
            material.addMaterial(new MovieMaterial(createMovieClip(text), true));
            return material;
        }
        
        private function createMovieClip(text:String):MovieClip {
            var tf:TextField = new TextField();
            tf.text = text;
            tf.autoSize = TextFieldAutoSize.LEFT;
            var format:TextFormat = new TextFormat("Impact", 240*2, 0x000000);
            tf.setTextFormat(format);

            var bmd:BitmapData = new BitmapData(tf.width, tf.height, true, 0x00ffffff);
            bmd.draw(tf, null, null, null, null, true);
            var bm:Bitmap = new Bitmap(bmd, "auto", true);
            bm.alpha = 0.7;

            var mc:MovieClip = new MovieClip();
            mc.addChild(bm);
            return mc;
        }
    }
}
