/**
 * Copyright gaina ( http://wonderfl.net/user/gaina )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/251i
 */

// forked from Event's Human Clock
package {
    
    /*
    龍安寺の石庭を観る
    5 2 3 2 3 の石
    */
    
    import com.bit101.components.Label;
    import flash.events.Event;
    import flash.events.TimerEvent;
    import flash.display.BlendMode;
    import flash.display.Sprite;
    import flash.display.StageScaleMode;
    import flash.display.StageAlign;
    import flash.geom.ColorTransform;
    import flash.utils.Timer;
    
    public class HumanClock extends Sprite {
        
        private var container:Array = [];
        
        private var Sec03:Array;
        private var Sec02:Array;
        private var Min03:Array;
        private var Min02:Array;
        private var Hour:Array;
        
        private var _sec:Array = [];
        private var _sec2:Array = [];
        private var _min:Array = [];
        private var _min2:Array = [];
        private var _hour:Array = [];
        
        private var background_sp:Sprite;
        private var fifth:Sprite;
        private var _text:Label;
        
        public function HumanClock() {
            initView();
            var timer:Timer = new Timer(1000);
            timer.addEventListener(TimerEvent.TIMER, onTimer);
            timer.start();
        }
        
        private function initView():void {
            stage.align = StageAlign.TOP;
            stage.scaleMode = StageScaleMode.SHOW_ALL;
            
            background_sp = new Sprite();
            background_sp.graphics.beginFill(0, 1);
            background_sp.graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
            background_sp.graphics.endFill();
            addChild(background_sp);
            
            _text = new Label(this, 415, 440);
            _text.blendMode = BlendMode.INVERT;
            addChild(_text);
            
            _hour = makeArray(5, 50, 150);
            
            _min2 = makeArray(2, 150, 80);
            _min = makeArray(3, 270, 230);
            
            _sec2 = makeArray(2, 350, 160);
            _sec = makeArray(3, 400, 280);
            
            Sec03 = ReturnArray(3);
            Sec02 = ReturnArray(2);
            
            Min03 = ReturnArray(3);
            Min02 = ReturnArray(2);
            
            Hour = ReturnArray(5);
            
            fifth = new Sprite();
            fifth.graphics.beginFill(0, 1);
            fifth.graphics.drawCircle(0, 0, 5);
            fifth.graphics.endFill();
            addChild(fifth);
            fifth.x = _hour[0].x + 8;
            fifth.y = _hour[0].y + 8;
            
            addEventListener(Event.ENTER_FRAME, loop);
            
            onTimer(null);
        }
        
        private function onTimer(e:TimerEvent):void {
            var time:Date = new Date;
            updateView(time.getHours(), time.getMinutes(), time.getSeconds());
        }
        
        private function updateView($hour:int, $min:int, $sec:int):void {
            var secString:String = addZero($sec);
            var sec10:Number = parseInt(secString.charAt(0));
            var sec1:Number = parseInt(secString.charAt(1));
            
            var minString:String = addZero($min);
            var min10:Number = parseInt(minString.charAt(0));
            var min1:Number = parseInt(minString.charAt(1));
            
            for (var i:int = 0; i < 3 ; i++) {
                _sec[i].scale = Sec03[sec1][i];
                _min[i].scale = Min03[min1][i];
            }
            
            for (var j:int = 0; j < 2; j++) {
                _sec2[j].scale = Sec02[sec10][j];
                _min2[j].scale = Min02[min10][j];
            }
            
            for (var k:int = 0; k < 4; k++) {
                _hour[k].scale = Hour[$hour%12][k];
            }
            
            _text.text = $hour.toString() + ":" + minString + ":" + secString;
            
            var col:ColorTransform = new ColorTransform();
            var sp_col:ColorTransform = new ColorTransform();
            if ( 5<$hour && 19>$hour ) {
                col.color = 0xFFFFFF;
                sp_col.color = 0x000000;
                background_sp.transform.colorTransform = col;
                fifth.transform.colorTransform = sp_col;
            }else {
                col.color = 0x000000;
                sp_col.color = 0xFFFFFF;
                background_sp.transform.colorTransform = col;
                fifth.transform.colorTransform = sp_col;
            }
        }
        
        private function addZero(_int:int):String {
            var str:String;
            if (_int < 10) {
                str = "0" + _int.toString();
            }else if (10 <= _int) {
                str = _int.toString();
            }
            return str;
        }
        
        private function loop(e:Event):void {
            for (var c:int = 0; c < container.length; c++) {
                var sp:ActiveDots = container[c] as ActiveDots;
                sp.Step();
            }
        }
        
        private function ReturnArray(num:int):Array {
            var arr:Array = [];
            if (num == 3) {
                arr = [[0, 0, 0],
                       [1, 0, 0],
                       [1, 1, 0],
                       [1, 1, 1],
                       [2, 1, 1],
                       [2, 2, 1],
                       [2, 2, 2],
                       [3, 2, 2],
                       [3, 3, 2],
                       [3, 3, 3]];
            }else if (num == 2) {
                arr = [[0, 0],
                       [1, 0],
                       [1, 1],
                       [2, 1],
                       [2, 2],
                       [3, 2]];
            } else if(num == 5) {
                arr = [[0, 0, 0, 0],
                       [1, 0, 0, 0],
                       [1, 1, 0, 0],
                       [1, 1, 1, 0],
                       [1, 1, 1, 1],
                       [2, 1, 1, 1],
                       [2, 2, 1, 1],
                       [2, 2, 2, 1],
                       [2, 2, 2, 2],
                       [3, 2, 2, 2],
                       [3, 3, 2, 2],
                       [3, 3, 3, 2]];
            }
            return arr;
        }
        
        private function makeArray(_num:int, x:Number = 100, y:Number = 100 ):Array {
            var arr:Array = [];
            for (var i:int = 0; i < _num; i++) {
                var sp:ActiveDots = new ActiveDots();
                
                if (_num % 2 == 0) {
                    sp.x = i *65 + x;
                    sp.y = y + Math.random() * 20 - 10;
                } else {
                    sp.x = x + Math.random() * 20 - 10;
                    sp.y = i *65 + y;
                }
                
                addChild(sp);
                arr.push(sp);
                container.push(sp);
                
                if (i == 3) {
                    break;
                }
            }
            return arr;
        }
    }
}

import flash.display.BlendMode;
import flash.display.Sprite;
import flash.events.Event;
import flash.events.EventDispatcher;

class ActiveDots extends Sprite
{
    private var sp:Sprite;
    public var scale:Number = 0;
        
    public function ActiveDots():void {
        graphics.beginFill(0, 1);
        graphics.drawCircle(0, 0, 8);
        graphics.endFill();
        this.blendMode = BlendMode.INVERT;
    }
        
    public function Step():void {
        this.scaleX += ((1 + 1 * scale) - this.scaleX) / 3;
        this.scaleY += ((1 + 1 * scale) - this.scaleY) / 3;
    }
    
}