/**
 * Copyright yd_niku ( http://wonderfl.net/user/yd_niku )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/23dQ
 */

package {
    //http://vimeo.com/11777370

    import flash.display.*;
    import flash.events.*;
    import flash.geom.*;
    import flash.filters.*;
    [SWF(backgroundColor="#000000")]
    public class FlashTest extends Sprite {
        
        private var _canvas:BitmapData;
        private var _force:BitmapData;
        
        private var _op:Point = new Point;
        private var _disp:BitmapFilter;
        private var _blur:BitmapFilter;
        
        private var _particles:Vector.<Particle> = new Vector.<Particle>();
        
        
        public function FlashTest() {
            var map:BitmapData = new BitmapData(465,465);
            map.perlinNoise( 32, 32, 1, 1,true,true );
            //addChild(new Bitmap(map));
            
            _force = new BitmapData(128,128);
            _force.perlinNoise( 64, 64, 1, 1,true,true );
            
            _disp = new DisplacementMapFilter(
                map, new Point(),
                BitmapDataChannel.RED, BitmapDataChannel.GREEN,
                16, 12,
                DisplacementMapFilterMode.WRAP,
                0x00, 1);
            _blur = new BlurFilter(2,2,1);
            
            graphics.beginFill(0x00);
            graphics.drawRect(0,0,465,465);
            graphics.endFill();
            
            _canvas = new BitmapData(465,465,true,0);
            addChild(new Bitmap(_canvas));
            
            
            const LENGTH:int=10000;
            for( var i:int=0;i<LENGTH; ++i){
               _particles.push(
                   new Particle(
                       Math.random()*465,
                       Math.random()*465
                   )
               );
            }
            
            addEventListener(Event.ENTER_FRAME,enterframeHandler);
        }
        
        
        private var _seed:int = 1;
        private function changeForceMap():void{
            _mapOffsets[0].x += 2;
            _mapOffsets[0].y += 1;
            _mapOffsets[1].x += 2;
            _mapOffsets[1].y += 1;
            _mapOffsets[2].x += 2;
            _mapOffsets[2].y += 1;
            
            _force.perlinNoise( 64, 64, 1, _seed, true,true,7, false, _mapOffsets );
        }
        
        private function changeForceMapSeed():void{
            _seed = Math.random()*10>>0 +1;
        }
        private var _timer:int = 0;
        private var _speed:Number = 1.5;
        private var _friction:Number = 0.99;
        private var _ctf:ColorTransform = new ColorTransform(0.99,0.96, 0.9,0.98, 0, 0, 0, 0);
        
        private var _mapOffsets:Array = [ new Point(), new Point(), new Point(), new Point() ];
        private function enterframeHandler(e:Event):void {
            
            if( _timer % 3 == 0 ) {
                changeForceMap();
            }
            else if( _timer % 23 ) {
                changeForceMapSeed();
            }
            else {
                _ctf.redOffset = ( _ctf.redOffset + 4 ) % 128;
                _ctf.blueOffset = ( _ctf.blueOffset + 4 ) % 64;
            }
            _timer++;
            
            _canvas.lock();
            
            
            for each( var p:Particle in _particles){
                var f:uint = _force.getPixel(p.x>>2,p.y>>2);
                
                p.vx = p.vx * _friction + ((f&0xFF)/0xFF-0.5) * _speed;
                p.vy = p.vy * _friction + (((f>>8)&0xFF)/0xFF-0.5) * _speed;
                p.x += p.vx +p.rdmX;
                p.y += p.vy +p.rdmY;
                
                if( p.x > 465 ) p.x -= 465;
                else if( p.x < 0 ) p.x += 465;
                if( p.y > 465 ) p.y -= 465;
                else if( p.y < 0 ) p.y += 465;
                
                _canvas.setPixel32( p.x, p.y, 0xFFFFFFCC )
            }
            
            
            _canvas.applyFilter(_canvas,_canvas.rect,_op,_disp);
            _canvas.applyFilter(_canvas,_canvas.rect,_op,_blur);
            _canvas.colorTransform(_canvas.rect,_ctf);
            
            _canvas.unlock();
        }
    }
}

class Particle{
    public var vx:Number;
    public var vy:Number;
    public var x:Number;
    public var y:Number;
    public var rdmX:Number = ( Math.random()-0.5 ) *0.1;
    public var rdmY:Number = ( Math.random()-0.5 ) *0.1;
    public function Particle(x:Number,y:Number,vx:Number=0,vy:Number=0){
        this.x = x;
        this.y = y;
        this.vx = vx;
        this.vy = vy;
    }
}
