/**
 * Copyright 084 ( http://wonderfl.net/user/084 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/23Y7
 */

//prog本からそのままコピペしただけ。wonderflで動くのですね。すごい！
package  
{
	import jp.progression.commands.display.RemoveChild;
	import jp.progression.casts.CastDocument;
	import jp.progression.casts.CastSprite;
	import jp.progression.commands.Trace;
	import jp.progression.commands.display.AddChild;
	import jp.progression.commands.tweens.DoTweener;
	import jp.progression.config.BasicAppConfig;

	import flash.events.MouseEvent;

	/**
	 * @author Mk-10:cellfusion
	 */
	public class CommandChainSample extends CastDocument 
	{
		public function CommandChainSample()
		{
			super("index", null, new BasicAppConfig());
		}

		override protected function atReady():void
		{
			// 親となる四角形を作成する
			var rect:CastSprite = new CastSprite();
			rect.graphics.beginFill(0x000000);
			rect.graphics.drawRect(0, 0, 100, 100);
			rect.graphics.endFill();
			
			// ディスプレイリストに登録時のコマンドを登録する
			rect.onCastAdded = function():void {
				this.addCommand(
					new Trace("rect onCastAdded コマンド開始"),
					new DoTweener(rect, {x:200, time:1, transition:"easeInOutCubic"}),
					new Trace("rect onCastAdded コマンド終了")
				);
			};
			
			// ディスプレイリストから削除時のコマンドを登録する
			rect.onCastRemoved = function():void {
				this.addCommand(
					new Trace("rect onCastRemoved コマンド開始"),
					new DoTweener(rect, {x:0, time:1, transition:"easeInOutCubic"}),
					new Trace("rect onCastRemoved コマンド終了")
				);
			};
			
			// 子となる四角形を作成する
			// 親と判別しやすくするため色と位置を変える
			var rect2:CastSprite = new CastSprite();
			rect2.mouseEnabled = false;
			rect2.graphics.beginFill(0x990000);
			rect2.graphics.drawRect(0, 0, 80, 80);
			rect2.graphics.endFill();
			
			rect2.x = 10;
			rect2.y = 10;
			
			// ディスプレイリストに登録時のコマンドを登録する
			rect2.onCastAdded = function():void {
				this.addCommand(
					new Trace("rect2 onCastAdded コマンド開始"),
					new DoTweener(rect2, {y:200, time:1, transition:"easeInOutCubic"}),
					new Trace("rect2 onCastAdded コマンド終了")
				);
			};
			
			// ディスプレイリストから削除時のコマンドを登録する
			rect2.onCastRemoved = function():void {
				this.addCommand(
					new Trace("rect2 onCastRemoved コマンド開始"),
					new DoTweener(rect2, {y:10, time:1, transition:"easeInOutCubic"}),
					new Trace("rect2 onCastRemoved コマンド終了")
				);
			};
			
			// 前もってディスプレイリストに追加する
			// このときにはまだ added 系のイベントは起こらない
			rect.addChild(rect2);
			
			// RemoveChild コマンドを実行させるための関数を登録する
			rect.addEventListener(MouseEvent.CLICK, click);
			
			// AddChild コマンドを作成し、実行する 
			var cmd:AddChild = new AddChild(this, rect);
			cmd.execute();
		}
		
		private function click(event:MouseEvent):void
		{
			// RemoveChild コマンドを作成し、実行する
			var cmd:RemoveChild = new RemoveChild(this, event.target);
			cmd.execute();
		}
	}
}
