/**
 * Copyright paq ( http://wonderfl.net/user/paq )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/22pp
 */

package 
{
	import Box2D.Common.Math.b2Vec2;
	import Box2D.Dynamics.b2Body;
	import com.actionsnippet.qbox.QuickBox2D;
	import flash.display.MovieClip;
	import flash.display.Sprite;
	import flash.events.Event;
	import idv.cjcat.stardust.common.clocks.SteadyClock;
	import net.hires.debug.Stats;
	
	/**
	 * ...
	 * @author paq89
	 */
	[SWF(backgroundColor="0xFFFFFF", width=465, height=465, frameRate=60)]
	public class Main extends Sprite 
	{
		private var _qbox:QuickBox2D;
		private var _emitter:QuickBox2DEmitter;
		private var _fixedPoint:b2Vec2 = new b2Vec2(7.75, 7.75);
		
		public function Main():void 
		{
			if (stage) init();
			else addEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		private function init(e:Event = null):void 
		{
			removeEventListener(Event.ADDED_TO_STAGE, init);
			
			_qbox = new QuickBox2D(addChild(new MovieClip()) as MovieClip, { gravityY:0 } );
			_qbox.createStageWalls();
			_qbox.start();
			
			_emitter = new QuickBox2DEmitter(new SteadyClock(0.2), _qbox);
			var renderer:QuickBox2DRenderer = new QuickBox2DRenderer(_qbox);
			renderer.addEmitter(_emitter);
			
			addEventListener(Event.ENTER_FRAME, loop);
			addChild(new Stats())
		}
		
		private function loop(e:Event):void 
		{
			_emitter.step();
			
			//----------------------------------------
			for (var body:b2Body = _qbox.w.m_bodyList; body ; body = body.GetNext())
			{
				if (body.IsSleeping())continue;
				
				var f:b2Vec2 = _fixedPoint.Copy();
				f.Subtract(body.GetPosition());
				f.Normalize();
				f.Multiply(5);
				f = f.Negative();
				body.ApplyForce(f, body.GetWorldCenter());
			}
			//----------------------------------------
		}
		
	}
	
}

// ここからStarudust
import com.actionsnippet.qbox.objects.BoxObject;
import com.actionsnippet.qbox.objects.CircleObject;
import com.actionsnippet.qbox.QuickBox2D;
import com.actionsnippet.qbox.QuickObject;
import flash.display.Sprite;
import idv.cjcat.stardust.common.actions.Age;
import idv.cjcat.stardust.common.actions.AlphaCurve;
import idv.cjcat.stardust.common.actions.DeathLife;
import idv.cjcat.stardust.common.actions.ScaleCurve;
import idv.cjcat.stardust.common.initializers.Initializer;
import idv.cjcat.stardust.common.initializers.Life;
import idv.cjcat.stardust.common.initializers.Scale;
import idv.cjcat.stardust.common.initializers.SwitchInitializer;
import idv.cjcat.stardust.common.math.UniformRandom;
import idv.cjcat.stardust.common.particles.Particle;
import idv.cjcat.stardust.common.utils.construct;
import idv.cjcat.stardust.common.xml.XMLBuilder;
import idv.cjcat.stardust.common.clocks.Clock;
import idv.cjcat.stardust.twoD.emitters.Emitter2D;
import idv.cjcat.stardust.twoD.initializers.Initializer2D;
import idv.cjcat.stardust.twoD.initializers.Position;
import idv.cjcat.stardust.twoD.zones.CircleZone;
import idv.cjcat.stardust.twoD.zones.Line;
import idv.cjcat.stardust.twoD.zones.RectZone;
import idv.cjcat.stardust.twoD.zones.SinglePoint;

class QuickBox2DEmitter extends Emitter2D
{
	public function QuickBox2DEmitter(clock:Clock, qbox:QuickBox2D):void 
	{
		super(clock);
		
		addInitializer(new QuickObjectClass(CircleObject, [qbox, {} ]));
		addInitializer(new Life(new UniformRandom(100, 0)));
		addInitializer(new Position(new CircleZone(7.75, 7.75, 1)));
		addInitializer(new Scale(new UniformRandom(0.5, 0.5)));
		
		addAction(new Age());
		addAction(new DeathLife());
		addAction(new AlphaCurve(5, 20));
		addAction(new ScaleCurve(5, 20));
	}
}

class QuickObjectClass extends Initializer2D 
{
	public var quickObjectClass:Class;
	public var constructorParams:Array;
	
	public function QuickObjectClass(quickObjectClass:Class = null, constructorParams:Array = null)
	{
		this.quickObjectClass = quickObjectClass;
		this.constructorParams = constructorParams;
	}
	
	override public function initialize(p:Particle):void
	{
		if (!quickObjectClass) return;
		p.target = construct(quickObjectClass, constructorParams);
	}
}

import flash.display.DisplayObject;
import flash.display.DisplayObjectContainer;
import idv.cjcat.stardust.common.events.EmitterEvent;
import idv.cjcat.stardust.common.particles.Particle;
import idv.cjcat.stardust.common.particles.ParticleIterator;
import idv.cjcat.stardust.common.renderers.Renderer;
import idv.cjcat.stardust.common.xml.XMLBuilder;
import idv.cjcat.stardust.twoD.display.AddChildMode;
import idv.cjcat.stardust.twoD.particles.Particle2D;

class QuickBox2DRenderer extends Renderer
{
	public var qbox:QuickBox2D;
	
	public function QuickBox2DRenderer(qbox:QuickBox2D = null)
	{
		this.qbox = qbox;
	}
	
	override protected function particlesAdded(e:EmitterEvent):void
	{
		if (!qbox) return;
		
		var particle:Particle2D;
		var iter:ParticleIterator = e.particles.getIterator();
		while (particle = iter.particle as Particle2D)
		{
			var quickObj:QuickObject = particle.target;
			quickObj.x = particle.x;
			quickObj.y = particle.y;
			quickObj.angle = particle.rotation;
			iter.next();
		}
	}
	
	override protected function particlesRemoved(e:EmitterEvent):void
	{
		var particle:Particle;
		var iter:ParticleIterator = e.particles.getIterator();
		while (particle = iter.particle)
		{
			var quickObj:QuickObject = particle.target;
			quickObj.destroy();
			iter.next();
		}
	}
	
	override protected function render(e:EmitterEvent):void
	{
		var particle:Particle2D;
		var iter:ParticleIterator = e.particles.getIterator();
		while (particle = iter.particle as Particle2D)
		{
			var quickObj:QuickObject = particle.target;
			quickObj.userData.alpha = particle.alpha;
			if (quickObj is CircleObject)
			{
				quickObj.shape.m_radius = particle.scale;
				quickObj.userData.scaleX = quickObj.userData.scaleY = particle.scale * 2;
			}
			iter.next();
		}
	}
}