/**
 * Copyright yangliu9812 ( http://wonderfl.net/user/yangliu9812 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/22m7
 */

// forked from ProjectNya's ColorCircle (3)
////////////////////////////////////////////////////////////////////////////////
// ColorCircle (3)
////////////////////////////////////////////////////////////////////////////////

package {

    import flash.display.Sprite;
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    import flash.display.Shape;
    import flash.events.Event;
    import flash.filters.BlurFilter;
    import frocessing.color.ColorHSV;

    [SWF(backgroundColor="#000000", width="465", height="465", frameRate="30")]

    public class Main extends Sprite {
        private var circle:Sprite;
        private var bitmapData:BitmapData;
        private var color:ColorHSV;
        private var grade:Number = 0;
        private var angle:Number = 0;
        private static var radian:Number = Math.PI/180;

        public function Main() {
            //Wonderfl.capture_delay(1);
            init();
        }

        private function init():void {
            graphics.beginFill(0x000000);
            graphics.drawRect(0, 0, 465, 465);
            graphics.endFill();
            //
            circle = new Sprite();
            addChild(circle);
            circle.x = 32;
            circle.y = 32;
            color = new ColorHSV();
            bitmapData = new BitmapData(400, 400, false, 0xFF000000);
            var bitmap:Bitmap = new Bitmap(bitmapData);
            circle.addChild(bitmap);
            bitmap.bitmapData.lock();
            for (var n:Number = 0; n < 360; n+=0.1) {
                color.h = n;
                for (var r:uint = 0; r < 202; r++) {
                    if (r < 100) {
                        color.s = r/100;
                        color.v = 1;
                    } else {
                        color.s = 1;
                        color.v = 2 - r/100;
                    }
                    var x:Number = 200 + r*Math.cos((n-90)*radian);
                    var y:Number = 200 + r*Math.sin((n-90)*radian);
                    bitmap.bitmapData.setPixel(x, y, color.value);
                }
            }
            bitmap.bitmapData.unlock();
            //
            var overlay:Shape = new Shape();
            overlay.graphics.beginFill(0x000000);
            overlay.graphics.drawCircle(0, 0, 200);
            overlay.graphics.endFill();
            overlay.x = 232;
            overlay.y = 232;
            bitmap.mask = overlay;
            //
            circle.filters = [new BlurFilter(32, 32, 3)];
            circle.alpha = 0.5;
            addEventListener(Event.ENTER_FRAME, update, false, 0, true);
        }
        private function update(evt:Event):void {
            angle += 2;
            grade = (Math.sin(angle*radian) + 1)/2;
            circle.alpha = grade;
        }

    }

}
