/**
 * Copyright echo ( http://wonderfl.net/user/echo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/22Oz
 */

// forked from garnet_fuji's 障害物飛び越えゲームの作成(未完成)
/* 
 *　右から左へ長方形の図形を平行移動させたものなのですが、
 *　移動している際に、長方形がちらついてしまいます。
 *　これはなにが原因なのでしょうか？
 */

package 
{
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Loader;
	import flash.display.Sprite;
	import flash.display.Shape;
	
	import flash.events.Event;
	import flash.events.KeyboardEvent;
	import flash.events.TimerEvent;
	
	import flash.utils.getTimer;
	import flash.utils.Timer;
	import flash.utils.setInterval;
	import flash.utils.clearInterval;
	
	import flash.ui.Keyboard;
	
	import flash.geom.Matrix;
	
	public class Main extends Sprite 
	{
		/** Screen と Buffer */
		public var buffer:BitmapData = new BitmapData(640, 480, false, 0x000000);
		public var screen:Bitmap = new Bitmap(buffer);
		/** 障害物の配列 */
		public var obstacles:Array = new Array();
		
		/**
		 * Main
		 */		
		public function Main():void 
		{
			if (stage) init();
			else addEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		/**
		 * 初期化(画像データの読み込み)
		 * @param	e
		 */
		private function init(e:Event = null):void 
		{
			removeEventListener(Event.ADDED_TO_STAGE, init);
			// entry point
			loadCompletedAll();
		}
		/**
		 * 読み込み(予定)が完了したら実行される
		 * @param	event
		 */
		public function loadCompletedAll():void {
			//スクリーンの追加
			addChild(screen);
			initBuffer();

			////周期実行
			//障害物の発生及び移動
			setInterval(makeObstacle, 1000);
			setInterval(moveObstacle, 40);
			
			////イベントリスナー
			//enterFlame(描画更新)
			addEventListener(Event.ENTER_FRAME, updata);
		}
		///
		/// 描画関連
		///
		/**
		 * バッファの初期化
		 */
		public function initBuffer():void {
			buffer.fillRect(buffer.rect, 0x000000);
		}
		/**
		 * 描画データの更新
		 */
		public function updata(event:Event):void {
			var i:int = 0;
			initBuffer();
			buffer.lock();
			for (i = 0; i < obstacles.length ; i++) {
				buffer.copyPixels(obstacles[i].bpData, obstacles[i].bpData.rect, obstacles[i].getPoint());
			}
			buffer.unlock();
		}
		
		///
		///　周期実行メソッド
		///
		/**
		 * setIntervalで障害物を発生させる
		 * @param	event
		 */
		public function makeObstacle():void {
			if(obstacles.length < 2){
				var	caseRand:int = Math.floor(Math.random() * 3 + 1);//1から3の値を返す
				var boxShape:Shape = makeRect(20, 85 * caseRand, getColor(), true);//障害物となるBOXを作成
				var tmp:BitmapData = new BitmapData(20, 85*caseRand);//ShapeをBitmapDataとして受け渡すための一時変数
				tmp.draw(boxShape);
				var obstacle:Obstacle = new Obstacle(tmp, 650, 460 - 85 * caseRand);//障害物の作成
				this.obstacles.push(obstacle);//配列に登録
			}
		}
		/**
		 * setInetrvalで障害物の移動と削除を行う
		 * @param	event
		 */
		public function moveObstacle():void {
			var obstacle:Obstacle;
			var i:int;
			buffer.lock();
			for (i = 0; i < this.obstacles.length; i++) {
				obstacle = this.obstacles[i];
				obstacle.move();
				if (obstacle.isOnStage() == false) {
					obstacles.splice(i, 1);
					i--;
					continue;
				}
			}
			buffer.unlock();
		}
		
		
		////
		//// 図形/色処理メソッド
		////
		
		/**
		 * 四角形の追加
		 * @param	w
		 * @param	h
		 * @param	color
		 * @param	line　ラインの有無
		 * @return
		 */
        private function makeRect(w:uint, h:uint, color:uint, line:Boolean):Shape {
            var rect:Shape = new Shape();
            rect.graphics.beginFill(color);
			if(line == true) rect.graphics.lineStyle(0, 0x000000);
            rect.graphics.drawRect(0, 0, w, h);
            rect.graphics.endFill();
            return rect;
        }
		/**
		 * ランダムで色を作る
		 * 障害物の色に使用
		 * @return r+g+b
		 */
		public function getColor():int{
			var r:int,g:int,b:int;
			r=0x10000*Math.random()*255;
			g=0x100*Math.random()*255;
			b=Math.random()*255;
			return r+g+b;
		}
	}	
}

import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.geom.Matrix;
import flash.geom.Point;

class Obstacle
{
	public var bpData:BitmapData;
	public var x:Number;
	public var y:Number;
	
	public function Obstacle(bd:BitmapData,x:Number,y:Number):void {
		this.bpData = bd;
		this.x = x;
		this.y = y;
	}
	
	public function move():void{
		x -= 15;
	}
	/**
	 * 座標を返す
	 * @return 
	 */		
	public function getPoint():Point {
		var p:Point = new Point(x, y);
		return p;
	}
	/**
	 * 平行移動のMatrixを返す
	 * @return
	 */
	public function getMatrix():Matrix {
		var m:Matrix = new Matrix(1, 0, 0, 1, x, y);
		return m;
	}
	/**
	 * ステージ外に障害物が出たかどうかの判定
	 * @return
	 */
	public function isOnStage():Boolean {
		if (x < 0) {
			return false;
		}else {
			return true;
		}
	}
}
