/**
 * Copyright goldsource ( http://wonderfl.net/user/goldsource )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/21vX
 */

package {
    import flash.geom.Point;
    import flash.events.MouseEvent;
    import flash.geom.Matrix;
    import flash.events.Event;
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    import flash.display.Sprite;
    /**
    * First Stack Overflow Test, something with pixels
    * MOVE WHILE DOWN
    * Have Fun
    * @author Nicholas Schreiber
    * @version 2
    *
    * For additional info and some more pixel fun visit  
    * http://goldsource.de
    *
    **/    
    public class FlashTest extends Sprite {
        
        /**
        * Horizontal Pixels
        **/
        public static const WIDTH:uint = 468;  
        
        /**
        * Vertical Pixels
        **/
        public static const HEIGHT:uint = 468;        
        
        /**
        * Emitter Speed Multiplicator
        **/
        public static const POWER:Number = .8;
        
        /**
        * Emitter Radius
        **/
        public static const RADIUS:Number = 6;
                
        /**
        * Pixels emitted simultaneous
        **/
        public static const PARTICLES:uint = 40;
        
        /**
        * Speed Damping
        **/
        public static const DAMPING:Number = .83;  
        
        /**
        * Max Mouse Speed px/frame
        **/
        public static const MAX_POTENTIAL:Number = 40;  
        
        /**
        * Min particle speed px/frame
        **/
        public static const MIN_SPEED:Number = .00001
        
        /**
        * Pixel Repository
        **/
        private var __pixels:Vector.<Pixel> = new Vector.<Pixel>
        
        /**
        * Main Screen
        **/
        private var __screen:Bitmap;   
        
        /**
        * Blank Bitmap
        **/     
        private var __blankBitmapData:BitmapData;
        
        /**
        * Last known mouse Position to calculate delta
        **/     
        private var __lastMouse:Point = new Point();      
        
        /**
        * Can't remember what this was for ;-)
        **/  
        private var __mouseIsDown:Boolean = false;
        
        /**
        * Info text
        **/      
        private var __info:Info = new Info();
            
        /**
        * Debug text
        **/
        private var __debug:Debug = new Debug()
                
        /**
        * Don't know how to rename a class yet. 
        **/        
        public function FlashTest() {            
            if(stage!=null){
                __init()
            }else{
                addEventListener(Event.ADDED_TO_STAGE,__onAddedToStage);
            }
        }
        
        private function __onAddedToStage($e:Event):void{
            removeEventListener(Event.ADDED_TO_STAGE,__onAddedToStage);
            __init();
        }
        
        /**
        * Setup Bitmaps and stuff
        **/
        private function __init():void{
            __screen = new Bitmap(new BitmapData(WIDTH,HEIGHT,true,0xFF000000),"auto",true);
            __blankBitmapData = new BitmapData(WIDTH,HEIGHT,true,0x02000000);               
            // adding the Screen
            addChild(__screen);  
            addChild(__debug);            
            __info.x = (WIDTH-__info.width)/2;
            __info.y = (HEIGHT-__info.height)/2;
            addChild(__info);
            
            // smooth motion please                   
            stage.frameRate = 60;
            // some listeners
            stage.addEventListener(MouseEvent.MOUSE_DOWN,__onMouseDown);           
            stage.addEventListener(Event.ENTER_FRAME,__onEnterFrame);               
        }           
        
        /**
        * Render the particles
        **/        
        private function __render():void{  
            // mouse delta           
            var potential:Number = Math.min(MAX_POTENTIAL,Math.sqrt(Math.pow(mouseX-__lastMouse.x, 2)+Math.pow(mouseY-__lastMouse.y, 2)));
            // fade screen
            __screen.bitmapData.draw(__blankBitmapData);
            if( __mouseIsDown){   
                // create some Particles
                for(var k:uint=0;k<PARTICLES;k++){
                    /* random Pixel 
                    *  Just a Square around Mousepoint
                    *  some round emitter would be nice
                    *  perhaps next version
                    */                             
                    var brightness:uint = Math.floor(Math.random()*0x99);                
                    var pixel:Pixel = new Pixel(mouseX+(Math.random()-Math.random())*RADIUS,mouseY+(Math.random()-Math.random())*RADIUS,(brightness << 16 | brightness << 8 | (brightness+Math.floor(Math.random()*(0xFF-brightness)))));  
                    var distance:Number = Math.sqrt(Math.pow(pixel.x-mouseX, 2)+Math.pow(pixel.y-mouseY, 2));              
                    // pixel speed (mouse speed, const mult and distance dependend)
                    pixel.speed += potential*POWER*distance/RADIUS;
                    // The movement angle (mouse direction, speed and position dependend) 
                    pixel.direction = Math.atan2(((pixel.x-mouseX)+(mouseX-__lastMouse.x)),((pixel.y-mouseY)+(mouseY-__lastMouse.y)));  
                    // remember the pixel                          
                    __pixels.push(pixel);
                }          
            }
            __debug.particles = __pixels.length;
            var i:uint = 0;
            while( i< __pixels.length){
                // for every pixel           
                if(__pixels[i].x<0 ||  __pixels[i].y<0 || __pixels[i].x>WIDTH || __pixels[i].y>HEIGHT || __pixels[i].speed<MIN_SPEED){
                   // delete if out of bounds or very slow
                   delete (__pixels.splice(i,1)[0]);
                }else{         
                    // move the pixels          
                    __pixels[i].x += __pixels[i].speed*Math.sin(__pixels[i].direction);
                    __pixels[i].y += __pixels[i].speed*Math.cos(__pixels[i].direction);
                    // slow down the pixel
                    __pixels[i].speed*=DAMPING;
                    // draw the pixel
                    __screen.bitmapData.setPixel(__pixels[i].x,__pixels[i].y,__pixels[i].color); 
                    i++
                }
            }  
            if(mouseX < 0 || mouseX > WIDTH || mouseY < 0 || mouseY > HEIGHT)return;
            // remember the mouse position
            __lastMouse.x = mouseX;
            __lastMouse.y = mouseY;            
        }   
        
        // Listeners
        private function __onEnterFrame($e:Event):void{   
            __render();
        }  
        
        private function __onMouseDown($e:MouseEvent):void{
            stage.removeEventListener(MouseEvent.MOUSE_DOWN,__onMouseDown);
            stage.addEventListener(MouseEvent.MOUSE_UP,__onMouseUp);
            __mouseIsDown = true;
        }
        
        private function __onMouseUp($e:MouseEvent):void{
            stage.removeEventListener(MouseEvent.MOUSE_UP,__onMouseUp);
            stage.addEventListener(MouseEvent.MOUSE_DOWN,__onMouseDown);
            __mouseIsDown = false;
        }
    }
}
import flash.filters.DropShadowFilter;
import flash.text.TextFieldAutoSize;
import flash.text.TextFormat;
import flash.text.TextField;

/**
* A single pixel
**/
internal class Pixel{
    public var color:uint = 0xFF000000;
    public var x:Number;
    public var y:Number;
    public var speed:Number = 0;
    public var direction:Number = 0;
    public function Pixel($x:uint,$y:uint,$color:uint){
        x=$x;
        y=$y;
        color = $color;       
    }
}

/**
* Info Field
**/
internal class Info extends TextField{    
    public var format:TextFormat = new TextFormat("_sans",32,0x333388,true);
    public function Info(){               
        filters = [new DropShadowFilter(2,45,0,.7,6,6,1.5,3)];           
        selectable = false;
        defaultTextFormat = format;
        autoSize = TextFieldAutoSize.LEFT;
        text="MOVE WHILE DOWN!";
    }
}

/**
* Debug Field
**/
internal class Debug extends TextField{
    public var format:TextFormat = new TextFormat("_sans",16,0x333388,true);
    public function Debug(){        
        filters = [new DropShadowFilter(2,45,0,.7,6,6,1.5,3)];   
        selectable = false;      
        defaultTextFormat = format;
        autoSize = TextFieldAutoSize.LEFT;
        text="0 Particles";
    }
    
    public function set particles($amount:uint):void {
        text=$amount+" Particles";
    }

}
