/**
 * Copyright jlbadrian ( http://wonderfl.net/user/jlbadrian )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/21Ho
 */

package {
    import flash.display.BitmapData;
    import flash.display.GradientType;
    import flash.display.InterpolationMethod;
    import flash.display.Shape;
    import flash.display.SpreadMethod;
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.geom.Matrix;
    
    public class AnimatedGradient extends Sprite
    {
        private var _fills:Array = [];
        private var _sortedFills:Array = [];
        private var _bmpMuestra:BitmapData; 
        private    var _cont:Number = 0;
        private    var _avance:Number = 1;
        private    var _colorInf:GradientColor = new GradientColor(0,0);
        private    var _colorSup:GradientColor = new GradientColor(0,255);
        private    var _indexInf:Number = -1;
        private    var _indexSup:Number = -1;
        private var _gradientWidth:Number = 2800;
        private var _gradientHeight:Number = 2800;
        private var _shape:Shape;
        
        public function AnimatedGradient()
        {
            this.addEventListener( Event.ADDED_TO_STAGE, this._onAddedToStage );
        }
        
        private function _onAddedToStage( evt:Event ):void
        {
            this.stage.align = flash.display.StageAlign.TOP_LEFT;
            this.stage.scaleMode = flash.display.StageScaleMode.NO_SCALE;
            this._init();
        }
        
        private function _init():void
        {
            _shape = new Shape();
            this.addChild( _shape );
            
            _fills.push( new GradientColor(0xFF0000,0) );
            _fills.push( new GradientColor(0x00FF00,63) );
            _fills.push( new GradientColor(0x0000FF,127) );
            _fills.push( new GradientColor(0x00FF00,191) );
            _fills.push( new GradientColor(0xFF0000,255) );
            
            var colors:Array = [];
            var alphas:Array = [];
            var ratios:Array = [];
            for each( var gc:GradientColor in _fills )
            {
                colors.push( gc.color );
                alphas.push( 0xff );
                ratios.push( gc.ratio );
            }
            var m:Matrix = new Matrix();
            m.createGradientBox( 255, 255 );
            var sp:Shape = new Shape();
            sp.graphics.beginGradientFill( GradientType.LINEAR, colors, alphas, ratios, m, SpreadMethod.PAD, InterpolationMethod.LINEAR_RGB ); 
            sp.graphics.drawRect( 0, 0, 255, 30 );
            _bmpMuestra = new BitmapData( 255, 30, false, 0xffffffff );
            _bmpMuestra.draw( sp );
            this.addEventListener( Event.ENTER_FRAME, this._onEnterFrame );
        }
        
        private function _sortFills():void
        {
            _sortedFills = [];
            var i:Number = 0;
            var j:Number = 0;
            var aux:Number;
            while(i < _fills.length)
            {
                _sortedFills.push(i);
                i++;
            }
            for(i = 0; i < _fills.length-1 ; i++)
            {
                for(j = i+1; j < _fills.length ; j++)
                {
                    if(_fills[_sortedFills[i]].ratio > _fills[_sortedFills[j]].ratio)
                    {
                        aux = _sortedFills[i];
                        _sortedFills[i] = _sortedFills[j];
                        _sortedFills[j] = aux;
                    }
                }
            }
        }
        
        private function _onEnterFrame( evt:Event ):void
        {
            if(_indexInf >= 0 )
            {
                _fills.splice(_indexInf, 1);
                _indexInf = -1;
                _indexSup--;
            }
            if(_indexSup >= 0 )
            {
                _fills.splice(_indexSup, 1);
                _indexSup = -1;
            }
            var i:Number = 0;
            while(i < _fills.length)
            {
                _fills[i].ratio += _avance;
                i++;
            }
            _cont += _avance;
            _cont = _cont%256;
            i=0;
            var hayLimiteInf:Boolean = false;
            var hayLimiteSup:Boolean = false;
            while(i < _fills.length)
            {
                if(!hayLimiteInf && _fills[i].ratio == 0)
                {
                    hayLimiteInf = true;
                }
                if(!hayLimiteSup && _fills[i].ratio == 255)
                {
                    hayLimiteSup = true;
                }
                i++;
            }
            var c:Number;
            if(!hayLimiteInf)
            {
                c = _bmpMuestra.getPixel32(255-_cont,0);
                _colorInf.alphaOffset = c >> 24 & 0xFF;
                _colorInf.color = c - _colorInf.alphaOffset*Math.pow(16,6);
                _indexInf = _fills.push(_colorInf)-1;
            }
            if(!hayLimiteSup)
            {
                c = _bmpMuestra.getPixel32(255-_cont,0);
                _colorSup.alphaOffset = c >> 24 & 0xFF;
                _colorSup.color = c - _colorSup.alphaOffset*Math.pow(16,6);
                _indexSup = _fills.push(_colorSup)-1;
            }
            var m:Matrix = new Matrix();
            var _gradientSize:Number = (stage.stageHeight > stage.stageWidth) ? stage.stageWidth*7 : stage.stageHeight*7;
            m.createGradientBox( _gradientSize, _gradientSize, 0, (stage.stageWidth - _gradientSize)/2, (stage.stageHeight - _gradientSize)/2 )//, (stage.stageWidth - _gradientWidth)/2, (stage.stageHeight - _gradientHeight)/2 );
            var colors:Array = [];
            var alphas:Array = [];
            var ratios:Array = [];
            this._sortFills();
            for each( var gc:Number in _sortedFills )
            {
                colors.push( _fills[gc].color );
                alphas.push( 0xff );
                ratios.push( _fills[gc].ratio );
            }
            
            _shape.graphics.clear();
            _shape.graphics.lineStyle(5, 0xffccff );
            _shape.graphics.beginGradientFill( GradientType.RADIAL, colors, alphas, ratios, m, SpreadMethod.REPEAT, InterpolationMethod.LINEAR_RGB ); 
            _shape.graphics.drawRect( 0,0,stage.stageWidth,stage.stageHeight);
            _shape.graphics.endFill();
        }
    }
}

import flash.geom.ColorTransform;    

class GradientColor extends ColorTransform
{
    private var _ratio:Number;
    
    function GradientColor (color:Number = 0xffffff, ratio:Number = 127)
    {
        super ();
        this.color = color;
        this.ratio = ratio;
    }
    public function get ratio():Number
    {
        return this._ratio;
    }
    public function set ratio(r:Number):void
    {
        this._ratio = (Math.abs(r))%256;
    }
}