/**
 * Copyright yonatan ( http://wonderfl.net/user/yonatan )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/20ir
 */

// I guess it is.
// For my attempt at a workaround see http://wonderfl.kayac.com/code/5587dec25ecd87aff4b7670f42352c61dcbb11c5

/*
According to http://livedocs.adobe.com/flex/3/langref/flash/geom/Matrix3D.html#interpolate()
.
"[Matrix3D.interpolate] simplifies the interpolation 
from one frame of reference to another by interpolating
a display object a percent point closer to a target
display object. The result is a new Matrix3D object 
where all the elements for the translation, rotation, 
*and scale* are interpolated to values between the 
current display object and the target display object."
.
It seems to ignore the scale. Am I missing something?

*/

package {
    import flash.display.Sprite;
    import flash.events.*;
    import flash.utils.*;
    import flash.geom.Matrix3D;

    public class Test extends Sprite {
        private var r:Sprite, g:Sprite, b:Sprite;

        public function Test() {
            var array:Array = [];

            for each( var color:uint in [0xFF0000,0x00FF00,0x0000FF] ) {
                var s:Sprite = new Sprite;
                s.graphics.beginFill( color );
                s.graphics.drawRect( 0, 0, 100, 100 );
                s.graphics.endFill();
                s.alpha = 0.5;
                addChild(s);
                array.push( s );
            }

            r = array[0];
            g = array[1];
            b = array[2];
            
            r.x = r.y = 30;
            r.rotationY = r.rotationY = 40;
            r.scaleX = r.scaleY = r.scaleZ = 0.5;

            b.rotationX = 80;
            b.x = b.y = 333;
            b.scaleX = b.scaleY = b.scaleZ = 0.5;

            addEventListener( Event.ENTER_FRAME, onEnter );
        }
        
        // use Matrix3D.interpolate to calculate a new matrix for g
        private function onEnter( e:Event ):void {
            var t:Number = Math.sin( getTimer()/1000 )/2+0.5;
            
            g.transform.matrix3D = Matrix3D.interpolate( r.transform.matrix3D, b.transform.matrix3D, t );
        }
    }
}