/**
 * Copyright aobyrne ( http://wonderfl.net/user/aobyrne )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/20BC
 */

// forked from Akiyah's QuickBox2D でぽにょぽにょさせてみた
package {
    import Box2D.Dynamics.b2Body;
    import com.bit101.components.Label;
    import flash.events.Event;
    import flash.display.*;
    import com.actionsnippet.qbox.*;
    import flash.geom.*;
    import Box2D.Common.Math.b2Vec2;
    import com.bit101.components.PushButton;
    import com.bit101.components.TextArea;

    public class JointGridMultiple extends MovieClip {
        private const frequencyHz:Number = 4;
        private const distance:Number = 0.5;
        private const dotNum:int = 4 + 1;
        private var sim:QuickBox2D;
        private var bGravity:Boolean;
        private var t:TextArea;
        

        public function JointGridMultiple() {
            sim = new QuickBox2D(this, { debug:false });
            sim.gravity = new b2Vec2(0, 0);
            createSoftness(new Point(2*distance, 2*distance) ,0xff0000,1,0,0,0,0,0,0,0);
            createSoftness(new Point(8*distance, 2*distance) ,0x00ff00,0,1,0,0,0,0,0,0);
            createSoftness(new Point(14*distance, 2*distance),0x0000ff,0,0,1,0,0,0,0,0);
            createSoftness(new Point(20*distance, 2*distance),0xff6600,0,0,0,1,0,0,0,0);
            
            createSoftness(new Point(2*distance, 8*distance) ,0xff0000,0,0,0,0,1,0,0,0);
            createSoftness(new Point(8*distance, 8*distance) ,0x00ff00,0,0,0,0,0,1,0,0);
            createSoftness(new Point(14*distance, 8*distance),0x0000ff,0,0,0,0,0,0,1,0);
            createSoftness(new Point(20*distance, 8*distance),0xff6600,0,0,0,0,0,0,0,1);
            
            createSoftness(new Point(2*distance, 14*distance) ,0xff0000,1,0,0,0,1,0,0,0);
            createSoftness(new Point(8*distance, 14*distance) ,0x00ff00,0,1,0,0,0,1,0,0);
            createSoftness(new Point(14*distance, 14*distance),0x0000ff,0,0,1,0,0,0,1,0);
            createSoftness(new Point(20*distance, 14*distance),0xff6600,0,0,0,1,0,0,0,1);
            
            sim.createStageWalls(); 
            sim.start();                        
            sim.mouseDrag();        
            new PushButton(this,0,0,"g",gravityToggle);
            t = new TextArea(this, 200, 0, "");
            t.visible = false;
            new Label(this, 105,0, "JointGridMultiple");
        }
        
        private function createSoftness(center:Point, lineColorArg:uint, 
        firstSet:int = 1, secondSet:int = 1, thirdSet:int = 1, fourthSet:int = 1, 
        firstSetA:int = 1, secondSetA:int = 1, thirdSetA:int = 1, fourthSetA:int = 1):void 
        {
            var dots:Array = [];
            var i:int;
            var j:int;
            var dot:QuickObject;
            for (j = 0; j < dotNum; j++) {
                var line:Array = [];
                dots.push(line);
                for (i = 0; i < dotNum; i++) {
                    dot = sim.addCircle({x:center.x + i*distance,
                                         y:center.y + j*distance,
                                         radius:0.1,
                                         groupIndex:-1,
                                         fixedRotation:true,
                                         friction:0.1,
                                         density:1,
                                         linearDamping:1,
                                         allowSleep:false,
                                         fillAlpha:0.5});
                                    
                    line.push(dot);
                }
            }
            sim.setDefault({type:QuickBox2D.REVOLUTE});
            for (j = 0; j < dotNum; j++) {
                for (i = 1; i < dotNum; i++) {
                    if(firstSet)sim.addJoint({a:dots[j][i-1].body, b:dots[j][i].body, frequencyHz:frequencyHz, lineColor:lineColorArg, lineThickness:3});
                    if(firstSetA)sim.addJoint({a:dots[i-1][j].body, b:dots[i][j].body, frequencyHz:frequencyHz, lineColor:lineColorArg*0.5, lineThickness:3});
                }
                for (i = 2; i < dotNum; i++) {
                    if(secondSet)sim.addJoint({a:dots[j][i-2].body, b:dots[j][i].body, frequencyHz:frequencyHz, lineColor:lineColorArg, lineThickness:3});
                    if(secondSetA)sim.addJoint({a:dots[i-2][j].body, b:dots[i][j].body, frequencyHz:frequencyHz, lineColor:lineColorArg*0.5, lineThickness:3});
                }
            }
        
            for (j = 1; j < dotNum; j++) {
                for (i = 1; i < dotNum; i++) {
                    if(thirdSet)sim.addJoint({a:dots[j-1][i-1].body, b:dots[j][i].body, frequencyHz:frequencyHz, lineColor:lineColorArg, lineThickness:3});
                    if(thirdSetA)sim.addJoint({a:dots[j-1][i].body, b:dots[j][i-1].body, frequencyHz:frequencyHz, lineColor:lineColorArg*0.5, lineThickness:3});
                }
            }
            
            for (j = 2; j < dotNum; j++) {
                for (i = 2; i < dotNum; i++) {
                    if(fourthSet)sim.addJoint({a:dots[j-2][i-2].body, b:dots[j][i].body, frequencyHz:frequencyHz, lineColor:lineColorArg, lineThickness:3});
                    if(fourthSetA)sim.addJoint({a:dots[j-2][i].body, b:dots[j][i-2].body, frequencyHz:frequencyHz, lineColor:lineColorArg*0.5, lineThickness:3});
                }
            }
        }
        
        private function cTrace(msg:String):void
        {
            t.text +="\n"+msg;
        }

        private function gravityToggle(e:Event):void
        {
            bGravity=!bGravity;
            sim.stop();
            if(bGravity)
            {
               cTrace('true');
               //sim.w.SetGravity(new b2Vec2(0,10));
               sim.gravity = new b2Vec2(0,10);
            }
            else
            {
                cTrace('false');
                //sim.w.SetGravity(new b2Vec2(0,0));
                sim.gravity = new b2Vec2(0,0);
           }
            sim.start();
            var body:b2Body = sim.w.GetBodyList();
            while (body) 
            {
                body.WakeUp();
                body = body.GetNext();
            }
        }

    }
}