/**
 * Copyright hacker_rs10vazy ( http://wonderfl.net/user/hacker_rs10vazy )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/1zyp
 */

// forked from Test_Dept's Rough Printed
//
// click stage to select your image.
//
package {

	import flash.display.Sprite;

	/**
	 * RoughPrinted
	 * @author Test Dept
	 */
	[SWF(backgroundColor="#ffffff", width="465", height="465")]
	public class RoughPrinted extends Sprite {

		public function RoughPrinted() {
			addChild(new RoughPrintedImpl() );
		}
	}
}

import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.BlendMode;
import flash.display.DisplayObject;
import flash.display.Graphics;
import flash.display.Loader;
import flash.display.LoaderInfo;
import flash.display.Sprite;
import flash.geom.ColorTransform;
import flash.geom.Matrix;
import flash.geom.Point;
import flash.geom.Rectangle;
import flash.events.Event;
import flash.events.MouseEvent;
import flash.net.FileFilter;
import flash.net.FileReference;
import flash.net.URLRequest;
import flash.system.LoaderContext;

class RoughPrintedImpl extends Sprite {

	private var _fileRef : FileReference;

	public function RoughPrintedImpl() {
		addEventListener(Event.ADDED_TO_STAGE, addedToStageHandler);
	}
	
	private function addedToStageHandler(event : Event) : void {

		var url : String = "http://assets.wonderfl.net/images/related_images/8/83/8305/8305445b4e41f37856f0c9d0751937e30e21c496m";

		var loader : Loader = new Loader();
		loader.contentLoaderInfo.addEventListener(Event.COMPLETE, loader_completeHandler);
		loader.load(new URLRequest(url), new LoaderContext(true) );
		
		stage.addEventListener(MouseEvent.MOUSE_DOWN, stage_mouseDownHandler);
	}

	private function loader_completeHandler(event : Event) : void {

		var loaderInfo : LoaderInfo = event.target as LoaderInfo;
		var bmp : Bitmap = loaderInfo.content as Bitmap;
		var dstBmp : BitmapData = Util.createPrintedIndirect(
			bmp, stage.stageWidth, stage.stageHeight, 80, 0xf0f0f0, 0.8);

		while (numChildren > 0) {
			removeChildAt(numChildren - 1);
		}

		addChild(new Bitmap(dstBmp) );
	}

	private function stage_mouseDownHandler(event : MouseEvent) : void {

		_fileRef = new FileReference();
		_fileRef.browse([
			new FileFilter("Image Files", "*.jpg;*.png"),
			new FileFilter("All Files", "*.*"),
		]);
		_fileRef.addEventListener(Event.SELECT, _fileRef_selectHandler);	
	}
	
	private function _fileRef_selectHandler(event : Event) : void {
		_fileRef.load();
		_fileRef.addEventListener(Event.COMPLETE, _fileRef_load_completeHandler);
	}

	private function _fileRef_load_completeHandler(event : Event) : void {

		var loader : Loader = new Loader();
		loader.loadBytes(_fileRef.data);
		loader.contentLoaderInfo.addEventListener(Event.COMPLETE, loader_completeHandler);
	}
}

class Util {
	
	public static function createPrintedIndirect(
		src : DisplayObject,
		width : int,
		height : int,
		dotSize : Number,
		paperColor : uint = 0xffffff,
		vivid : Number = 1
	) : BitmapData {

		var srcBmp : BitmapData = new BitmapData(width, height);
		var scale : Number = (src.width / src.height > width / height)?
			height / src.height : width / src.width;			
		var mat : Matrix = new Matrix(
			scale, 0, 0, scale, 
			(width - scale * src.width) / 2, 
			(height - scale * src.height) / 2);
		srcBmp.draw(src, mat);
		return createPrinted(srcBmp, dotSize, paperColor, vivid);
	}
	
	public static function createPrinted(
		srcBmp : BitmapData, dotSize : Number,
		paperColor : uint = 0xffffff,
		vivid : Number = 1
	) : BitmapData {

		var dstBmp : BitmapData = new BitmapData(
			srcBmp.width, srcBmp.height, false, paperColor);

		var ct : ColorTransform = new ColorTransform(vivid, vivid, vivid);

		// Y
		dstBmp.draw(createHalftone(srcBmp, dotSize, 0xff, 0),
			null, ct, BlendMode.SUBTRACT);
		// M
		dstBmp.draw(createHalftone(srcBmp, dotSize, 0xff << 8, 15),
			null, ct, BlendMode.SUBTRACT);
		// C
		dstBmp.draw(createHalftone(srcBmp, dotSize, 0xff << 16, 30),
			null, ct, BlendMode.SUBTRACT);

		return dstBmp;
	}
	
	public static function createHalftone(
		srcBmp : BitmapData, dotSize : Number,
		mask : int, angle : Number
	) : BitmapData {

		var color : uint = 0xff033660 | mask;

		//--------------------
		// base
		
		var dstBmp : BitmapData = new BitmapData(
			srcBmp.width, srcBmp.height, false, 0);
		dstBmp.threshold(srcBmp,
			new Rectangle(0, 0, srcBmp.width, srcBmp.height),
			new Point(0, 0), "<=", mask >>> 1, color, mask);

		//--------------------
		// create pattern

		var pattern : Sprite = new Sprite();
		var g : Graphics = pattern.graphics;
		g.clear();
		
		createPattern(dstBmp.width, dstBmp.height, dotSize, angle * Math.PI / 180,
			function(x : Number, y : Number) : void {

				var s : Number = (mask & srcBmp.getPixel(x, y) ) / mask;
				var rev : Boolean = false;
				
				if (s > 0.5) {
					s = 1.0 - s;
					rev = true;
				}
				
				var r : Number = Math.sqrt(s * dotSize * dotSize / Math.PI);
				g.beginFill(rev? color : 0);
				g.drawCircle(x, y, r);
				g.endFill();
			}
		);

		dstBmp.draw(pattern);
		
		return dstBmp;
	}

	private static function createPattern(
		width : Number,
		height : Number,
		dotPitch : Number,
		angle : Number,
		handler : Function
	) : void {
		
		if (angle < 0 || angle >= Math.PI / 2) {
			throw new Error("bad angle:" + angle);
		}
		
		var mat : Matrix = new Matrix();
		mat.rotate(angle);
		
		var numDots : int = Math.max(width / dotPitch, height / dotPitch);
		
		var dx : Point = mat.transformPoint(new Point(dotPitch, 0) );

		for (var iy : int = -numDots; iy < numDots; iy++) {
			
			var p : Point = mat.transformPoint(new Point(0, iy * dotPitch) );

			while (p.x < 0) {
				p = p.add(dx);
			}

			while (p.x < width && p.y < height) {
				handler(p.x, p.y);
				p = p.add(dx);
			}
		}
	}
}
