/**
 * Copyright mousepancyo ( http://wonderfl.net/user/mousepancyo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/1zw1
 */

package  {
    import flash.display.Sprite;
    import flash.geom.Point;
    import flash.events.Event;
    import flash.display.Sprite;
    import flash.events.MouseEvent;
    
    public class Main extends Sprite{
        
        private var rotObj:Sprite = new RotObj();
        private var _r:Number;
        private var _rad:Number;
        private var _radius:Number;
        private var _centerX:Number = stage.stageWidth / 2;
        private var _centerY:Number = stage.stageHeight / 2;
        private var _p:Point = new Point(_centerX, _centerY);
        private var _isMouseDown:Boolean;
        
       [SWF(width="465", height="465", backgroundColor="0xFFFFFF", frameRate="60")]
        public function Main() {
            addChild(rotObj);
            rotObj.x = _centerX;
            rotObj.y = _centerY;
            stage.addEventListener(MouseEvent.MOUSE_DOWN, onDown);
            stage.addEventListener(MouseEvent.MOUSE_UP, onUp);
            graphics.lineStyle(1, 0);
            //
            Wonderfl.capture_delay(40);
        }
        
        private function update(e:Event):void{
            rotObj.rotation +=5;
            _r = rotObj.rotation;
            _rad = _r * Math.PI / 180;
            
            if(_isMouseDown){
                _p.x = _centerX + Math.cos(_rad) * Point.distance(new Point(_centerX, _centerY), new Point(mouseX, mouseY));
                _p.y = _centerY + Math.sin(_rad) * Point.distance(new Point(_centerX, _centerY), new Point(mouseX, mouseY));
                graphics.lineTo(_p.x, _p.y);
            }
        }
        
        private function onDown(e:MouseEvent):void{
            _isMouseDown = true;
            _p.x = mouseX;
            _p.y = mouseY;
            var rad:Number = Math.atan2(mouseY - _centerY, mouseX - _centerX);
            rotObj.rotation = rad * 180 / Math.PI;
            //
            graphics.moveTo(_p.x, _p.y);
            addEventListener(Event.ENTER_FRAME, update);
        }
        private function onUp(e:MouseEvent):void{
            _isMouseDown = false;
            graphics.clear();
            graphics.lineStyle(1, 0);
            graphics.moveTo(_p.x, _p.y);
            removeEventListener(Event.ENTER_FRAME, update);
            rotObj.rotation = 0;
        }
    }
}

import flash.display.Sprite;
class RotObj extends Sprite{
    public function RotObj() {
        this.graphics.lineStyle(1, 0x990000);
        graphics.moveTo(0, 0);
        graphics.lineTo(-10, 0);
        graphics.moveTo(0, 0);
        graphics.lineTo(0, -10);
        graphics.moveTo(0, 0);
        graphics.lineTo(10, 0);
        graphics.moveTo(0, 0);
        graphics.lineTo(0, 10);
    }
}