/**
 * Copyright gaina ( http://wonderfl.net/user/gaina )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/1zUP
 */

package 
{
    import flash.events.MouseEvent;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.filters.BlurFilter;
    import flash.geom.Point;
    import flash.media.Sound;
    import flash.media.SoundChannel;
    import flash.media.SoundLoaderContext;
    import flash.media.SoundMixer;
    import flash.media.SoundTransform;
    import flash.net.URLRequest;
    import flash.system.Security;
    import flash.utils.ByteArray;
    
    [SWF(width = 465, height = 465 )]
    public class Main extends Sprite
    {
        private var snd:Sound;
        private var sndChannel:SoundChannel;
        private var _points:Array;
        private var _container:Sprite;
        private var _bitmapdata:BitmapData;
        private var _color:uint;
        private var _p:Point;
        
        public function Main():void 
        {            
            _points = [];
            
            _container = new Sprite();
            _bitmapdata = new BitmapData(465, 465);
            var _bitmap:Bitmap = new Bitmap(_bitmapdata);
            addChild(_bitmap);
            
            _color = 0xFF0000;
            
            _p = new Point();
            
            for (var i:int = 0; i < 512; i++)
            {
                var p:Point = new Point();
                p.x = Math.random() * 465;
                p.y = Math.random() * 465;
                _points.push(p);
            }
            
            Security.allowDomain("takasumi-nagai.com");
            playSound("http://www.takasumi-nagai.com/soundfiles/sound004.mp3");
        }
        
        private function playSound(sndUrl:String):void
        {
            snd = new Sound();
            var context:SoundLoaderContext = new SoundLoaderContext(10,true);
            var req:URLRequest = new URLRequest(sndUrl);
            snd.load(req, context);
            snd.addEventListener(Event.COMPLETE, onComp);
        }
        
        private function onComp(e:Event):void 
        {
            sndChannel=new SoundChannel();
            sndChannel = snd.play(0, 10, new SoundTransform(0.3, 0));
            addEventListener(Event.ENTER_FRAME, loop);
            
            stage.addEventListener(MouseEvent.MOUSE_DOWN, clear);
        }
        
        private function loop(event:Event):void 
        {
            var _bytes:ByteArray = new ByteArray();
            SoundMixer.computeSpectrum(_bytes, true, 0);
            _bytes.position = 0;
            
            var data:Number = 0;
            
            _container.graphics.clear();
            _container.graphics.lineStyle(2, _color, 0.8);
            for (var i:int = 0; i < 512; i++)
            {
                var p:Point = _points[i] as Point;
                var d:Number = _bytes.readFloat();
                data += d;
                if (i == 0) {
                    _container.graphics.moveTo(p.x, p.y);
                }else {
                    if (d > 0.25) {
                        _container.graphics.curveTo(_p.x, _p.y, p.x, p.y);
                    }
                }
            }
            this.graphics.endFill();
            
            
            
            
            if (data > 10) {
                change();
            }
            
            _bitmapdata.lock();
            if (data > 16) {
                _bitmapdata.draw(new BitmapData(465, 465, true, 0xDDFFFFFF));
            }else{
                _bitmapdata.draw(_container);
                _bitmapdata.applyFilter(_bitmapdata, _bitmapdata.rect, new Point(10,0), new BlurFilter(4,4));
            }
            _bitmapdata..unlock();
            
            _p.x = mouseX;
            _p.y = mouseY;
        }
        
        private function clear(e:MouseEvent):void
        {
            _bitmapdata.draw(new BitmapData(465, 465, false, 0xFFFFFFFF));
        }

        
        private function change():void 
        {
            for (var i:int = 0; i < _points.length; i++)
            {
                var p:Point = _points[i] as Point; 
                p.x = Math.random() * 465;
                p.y = Math.random() * 465;
            }
            if (_color == 0xFF0000) {
                _color = 0x00FF00;
            }else if(_color == 0x00FF00) {
                _color = 0x0000FF;
            }else if (_color == 0x0000FF) {
                _color = 0xFF0000;
            }
        }
    }
}