/**
 * Copyright greentec ( http://wonderfl.net/user/greentec )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/1zT0
 */

package 
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.Point;
    
    /**
     * ...
     * @author ypc
     */
    [SWF(width = "465", height = "465", backgroundColor = "#ffffff")]
    public class Main extends Sprite 
    {
        public var tileBitmapData:BitmapData = new BitmapData(100, 100, true);
        public var randomSeed:int = Math.random() * int.MAX_VALUE;
        public var offsets:Array = [];
        public var speeds:Array = [];
        public var numOctaves:int = 6;
        public var numOctavesMax:int = 6;
        public var channelOptions:int = 15;//Math.random() * 15 + 1;
        public var stitch:Boolean = true;
        public var fractalNoise:Boolean = false;
        
        public var triCellArray:Array = [];
        public var rowNum:int = 28;
        public var colNum:int = 50;
        
        public function Main():void 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            // entry point
            
            stage.scaleMode = "noScale";
            
            var i:int;
            var j:int;
            var triCell:TriCell;
            var edgeLength:int = 20;
            var cellWidth:Number = edgeLength;
            var cellHeight:Number = cellWidth * Math.sqrt(3) / 2;
            var indentX:Number = -cellWidth / 2;
            var indentY:Number = -cellHeight / 2;
            var color:uint;
            //var colorArray:Array = [0x00a9e5, 0x1778e7, 0x2e53ea, 0x5447ec, 0x925fef, 0xc579f2, 0xeb92f4, 0xf7adea, 0xf9c7e3, 0xfce3ea, 0xffffff];
            
            for (i = 0; i < numOctaves; i += 1)
            {
                offsets[i] = new Point(0, 0);
                speeds.push(new Point(Math.random() * 8 - 4, Math.random() * 8 - 4));
            }
            
            tileBitmapData.perlinNoise(rowNum, colNum, numOctaves, randomSeed, stitch, fractalNoise, channelOptions, false, offsets);
            
            for (i = 0; i < rowNum; i += 1)
            {
                for (j = 0; j < colNum; j += 1)
                {    
                    triCell = new TriCell(j, i, false, edgeLength);
                    triCell.y = i * cellHeight + indentY;
                    if (i % 2 == 1)
                    {
                        triCell.x = int(j / 2) * cellWidth - cellWidth / 2 + indentX;
                        if (j % 2 == 1)
                        {
                            triCell.x += cellWidth;
                        }
                    }
                    else
                    {
                        triCell.x = int(j / 2) * cellWidth + indentX;
                    }
                    
                    color = noiseColor(tileBitmapData.getPixel(triCell._x, triCell._y));
                    triCell.drawCell(color);
                    triCell.mouseEnabled = false;
                    //triCell.addEventListener(MouseEvent.CLICK, onMouseClick);
                    addChild(triCell);
                    triCellArray.push(triCell);
                }
            }
            
            addChild(new Bitmap(tileBitmapData));
            
            addEventListener(Event.ENTER_FRAME, onLoop);
            stage.addEventListener(MouseEvent.CLICK, onClick);
        }
        
        private function noiseColor(color:uint):uint
        {
            var r:uint = (color >> 16) & 0xff;
            var g:uint = (color >> 8) & 0xff;
            var b:uint = color & 0xff;
            
            r += Math.random() * 0x14 - 0xA;
            g += Math.random() * 0x14 - 0xA;
            b += Math.random() * 0x14 - 0xA;
            
            r = Math.min(Math.max(0x0, r), 0xff);
            g = Math.min(Math.max(0x0, g), 0xff);
            b = Math.min(Math.max(0x0, b), 0xff);
            
            return (r << 16) | (g << 8) | b;
        }
        
        private function onClick(e:MouseEvent):void
        {
            randomSeed = Math.random() * int.MAX_VALUE;
            //channelOptions = Math.random() * 15 + 1;
            stitch = Math.random() < 0.5 ? true : false;
            fractalNoise = Math.random() < 0.5 ? true : false;
            numOctaves = Math.random() * 5 + 2;
            
            var i:int;
            
            for (i = 0; i < numOctavesMax; i += 1)
            {
                speeds[i] = new Point(Math.random() * 8 - 4, Math.random() * 8 - 4);
            }
        }
        
        private function onLoop(e:Event):void
        {
            var i:int;
            for (i = 0; i < numOctaves; i += 1)
            {
                offsets[i].x += speeds[i].x;
                offsets[i].y += speeds[i].y;
            }
            
            tileBitmapData.perlinNoise(100, 100, numOctaves, randomSeed, stitch, fractalNoise, channelOptions, false, offsets);
            
            var len:int = triCellArray.length;
            var color:uint;
            var triCell:TriCell;
            for (i = 0; i < len; i += 1)
            {
                triCell = triCellArray[i];
                color = noiseColor(tileBitmapData.getPixel(triCell._x, triCell._y))
                triCell.drawCell(color);
            }
            
        }
        
        //private function onMouseClick(e:MouseEvent):void
        //{
            //var triCell:TriCell = e.target.parent as TriCell;
            //trace(triCell._x, triCell._y);
        //}
        
    }
}

Class  
{
    import flash.display.Sprite;
    /**
     * ...
     * @author ypc
     */
    class TriCell extends Sprite
    {
        public var _x:int;
        public var _y:int;
        public var edgeLength:int;
        public var _G:Sprite;
        
        public function TriCell(_x:int, _y:int, _draw:Boolean = true, edge:int = 20, color:uint = 0x000000) 
        {
            this._x = _x;
            this._y = _y;
            this.edgeLength = edge;
            
            _G = new Sprite();
            addChild(_G);
            
            if (_draw)
            {
                drawCell(color);
            }
        }
        
        public function drawCell(color:uint = 0x000000):void
        {
            _G.graphics.clear();
            _G.graphics.lineStyle(1, color);
            _G.graphics.beginFill(color);
            var h:Number = edgeLength * Math.sqrt(3) / 2;
            
            if ((_x + _y) % 2 == 0) //normal triangle
            {
                with (_G.graphics)
                {
                    moveTo(0, 0);
                    lineTo( -edgeLength / 2, h);
                    lineTo( edgeLength / 2, h);
                    lineTo(0, 0);
                    endFill();
                }
            }
            else //inverted triangle
            {
                with (_G.graphics)
                {
                    moveTo(0, 0);
                    lineTo(edgeLength / 2, h);
                    lineTo(edgeLength, 0);
                    lineTo(0, 0);
                    endFill();
                }
            }
            
        }
    }
}