/**
 * Copyright actionscriptbible ( http://wonderfl.net/user/actionscriptbible )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/1zKt
 */

package {
  import flash.display.Shape;
  import flash.display.Sprite;
  import flash.events.KeyboardEvent;
  import flash.events.MouseEvent;
  import flash.geom.Point;
  
  public class ch35ex5 extends Sprite {
    protected var pts:Vector.<Point>;
    protected var curve:Shape;
    protected var points:Shape;

    public function ch35ex5() {
      points = new Shape();
      addChild(points);
      curve = new Shape();
      addChild(curve);
      //click to add a point
      stage.addEventListener(MouseEvent.CLICK, onClick);
      //press any key to clear the screen
      stage.addEventListener(KeyboardEvent.KEY_DOWN, onKeyDown);
      onKeyDown(null);
    }
    
    protected function onClick(event:MouseEvent):void {
      var p:Point = new Point(stage.mouseX, stage.mouseY);
      pts.push(p);
      drawCurve();
      //the points you originally clicked will be displayed
      points.graphics.drawCircle(p.x, p.y, 2);
    }
    
    protected function onKeyDown(event:KeyboardEvent):void {
      pts = new Vector.<Point>();
      curve.graphics.clear();
      points.graphics.clear();
      points.graphics.lineStyle(1, 0, 0.5);
    }
    
    protected function drawCurve():void {
      if (pts.length < 3) return;
      curve.graphics.clear();
      curve.graphics.lineStyle(1);
      curve.graphics.moveTo(pts[0].x, pts[0].y);
      for (var i:int = 0; i < pts.length - 2; i += 2) {
        curve.graphics.curveTo(pts[i+1].x, pts[i+1].y, pts[i+2].x, pts[i+2].y);
      }
    }
  }
}