/**
 * Copyright h6k ( http://wonderfl.net/user/h6k )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/1zJy
 */

package {
    import flash.display.Sprite;
    import flash.display.Shape;
    import flash.text.TextField;
    import flash.events.Event;
    import flash.events.KeyboardEvent;
    import flash.utils.getTimer;
    import flash.geom.Matrix;
    
    public class FlashTest extends Sprite {
    		private var sfld:TextField = new TextField();	// スコアフィールド
    		private var sw:int = stage.stageWidth;		// ステージ幅
    		private var sh:int = stage.stageHeight;		// ステージ高さ
         
        private var make:int;			// 何フレーム毎にバーを出すか
        private var frame:uint;			// フレームカウンタ
        private var stimer:uint;			// スタート時間
        private var dx:int = 3;			// X移動量
        private var dy:Number;			// Y移動量
        private var bcnt:uint;			// バーの消えた数
        private var gameover:Boolean;		// ゲームオーバーフラグ
        private var drop:uint;			// 落ち始め時間
        private var ride:int;			// バーに乗っているか
   		
        public function FlashTest() {
            // write as3 code here..
            makeStage();
            stage.addEventListener(KeyboardEvent.KEY_DOWN, onKeyDown);
            stage.addEventListener(KeyboardEvent.KEY_UP, onKeyUp);
            stage.addEventListener(KeyboardEvent.KEY_DOWN, onAnyKey);
        }
        
        // キーボードイベント
        private var left:Boolean = false;
        private var right:Boolean = false;
        private function onAnyKey(e:KeyboardEvent):void {
        		if(e.keyCode != 37 && e.keyCode != 39) {
        			stage.removeEventListener(KeyboardEvent.KEY_DOWN, arguments.callee);
        			GameStart();
        		}
        }
        private function onKeyDown(e:KeyboardEvent):void {
        		if(e.keyCode == 37) {
        			left = true;
        		}
        		if(e.keyCode == 39) {
        			right = true;
        		}
        }
        private function onKeyUp(e:KeyboardEvent):void {
        		if(e.keyCode == 37) {
        			left = false;
        		}
        		if(e.keyCode == 39) {
        			right = false;
        		}
        }
        
        // ゲームスタート
        private function GameStart():void {
        		while (numChildren > 0) {
				removeChildAt(0);
			}
			
			// 初期化
			make = 60;
			frame = 0;
			stimer = getTimer();
			dy = 1;
			bcnt = 0;
			gameover = false;
			drop = stimer;
			ride = 0;
			
			makeStage();
			makeOwn();
			stage.addEventListener(Event.ENTER_FRAME, judge);
        }
        
        // 判定
        private function judge():void {
			var score:uint = getTimer() - stimer;
			var str:String = "0000000" + score;
			sfld.text = "SCORE : " + str.substr(str.length - 7);
			
			 if (gameover) {
			 	// ゲームオーバー
				stage.removeEventListener(Event.ENTER_FRAME, arguments.callee);
				stage.addEventListener(KeyboardEvent.KEY_DOWN, onAnyKey);
				sfld.appendText("\nPRESS ANY KEY TO PLAY!");
			} else if (frame++ % make == 0) {
				// バー出現
				makeBar();
			}
			
			// 自機移動
			switch(ride) {
				case 1:
					// 通常バー
					own.y -= dy;
					break;
				case 2:
					// <-
					own.x -= dx / 2;
					break;
				case 3:
					// ->
					own.x += dx / 2;
					break;
				default:
					// 落下
					own.y += 9.8 * Math.pow((getTimer() - drop) / 1000, 2) / 3;
			}
			
			// x方向移動
			if (left) {
				if(own.x - or - dx >= 0) {
					own.x -= dx;
				}
			}
			if (right) {
				if(own.x + or + dx <= sw) {
					own.x += dx;
				}
			}
        }
        
		// バー作成
		private var bw:int = 50;				// バー幅
		private var bh:Number = or * 1.5;		// バー高さ
		private function makeBar():void {
			var t:int;
			var bar:Shape = new Shape();
			addChild(bar);
			
			if (frame < make) {
				// 初回
				bar.x = sw / 2 - (bw / 2);
				t = 0;
			} else {
				bar.x = Math.random() * (sw - bw);
				t = Math.random() * 6;
			}
			
			bar.y = sh;
			var matrix:Matrix = new Matrix();
			matrix.createGradientBox(bw, bh, Math.PI / 2);
			bar.graphics.beginGradientFill("linear", [0xFFFFFF, 0], [1, 1], [0, 255], matrix);
			bar.graphics.drawRect(0, 0, bw, bh);
			bar.graphics.endFill();
			
			switch(t) {
				case 1:
					// 左移動バー
					bar.graphics.beginFill(0, 1);
					bar.graphics.moveTo(or * 2, or);
					bar.graphics.lineTo(0, or);
					bar.graphics.lineTo(or, 0);
					bar.graphics.lineTo(or, or);
					bar.graphics.lineTo(or * 2, 0);
					bar.graphics.lineTo(or * 2, or);
					bar.graphics.endFill();
					break;
				case 2:
					// 右移動バー
					bar.graphics.beginFill(0, 1);
					bar.graphics.moveTo(bw - (or * 2), or);
					bar.graphics.lineTo(bw, or);
					bar.graphics.lineTo(bw - or, 0);
					bar.graphics.lineTo(bw - or, or);
					bar.graphics.lineTo(bw - (or * 2), 0);
					bar.graphics.lineTo(bw - (or * 2), or);
					bar.graphics.endFill();
					break;
				case 3:
					// アウト
					bar.graphics.beginFill(0xFFFFFF, 1);
					bar.graphics.moveTo(0, 0);
					for (var i:int = 1; i <= 40; i++) {
						bar.graphics.lineTo(or / 4 * i, -or * (i % 2));
					}
					bar.graphics.endFill();
					break;
			}
			bar.addEventListener(Event.ENTER_FRAME, onBarMove(bar, t + 1));
		}

		// バー移動
		private var onShape:Shape;	// 乗っているバー
		private function onBarMove(bar:Shape, type:int):Function {
			return function(e:Event):void {
				if (contains(bar)) {
					// 落下スタート
					if (bar == onShape && ride != 0) {
						ride = 0;
						drop = getTimer();
					}
					
					// 着地
					if(bar.hitTestObject(own)) {
						own.y = bar.y - or - dy;
						ride = type;
						if (type == 4) {
							// アウト
							gameover = true;
						}
						onShape = bar;
					}
					
					// バー画面外判定
					if (bar.y + bh < 0) {
						bar.removeEventListener(Event.ENTER_FRAME, arguments.callee);
						removeChild(bar);
						
						// 何となく速くしていく
						if (++bcnt % 3 == 0) {
							if(dy < or) {
								dy *= 1.05;
							}
							if (make > 6) {
								make -= 2;
							}
						}
					} else {
						bar.y -= dy;
					}
				}
				
				// 自機画面外判定
				if (own.y + or < 0 || own.y - or > sh) {
					gameover = true;
				}
			}
		}
		
        // 自機作成
        private var own:Shape = new Shape();
        private var or:int = 5;	// 半径
        private function makeOwn():void {
			var matrix:Matrix = new Matrix();
			matrix.createGradientBox(or * 2, or * 2, Math.PI / 2);
			own.graphics.beginGradientFill("linear", [0xFF0000, 0], [1, 1], [0, 255], matrix);
			own.graphics.drawCircle(0, 0, or);
			own.graphics.endFill();
			own.x = sw / 2 - (or / 2);
			own.y = 0;
			addChild(own);
        }
		
        // ステージ作成
        private function makeStage():void {
        		var st:Shape = new Shape();
        		addChild(st);
        		st.graphics.beginFill(0, 1);
        		st.graphics.drawRect(0, 0, sw, sh);
        		st.graphics.endFill();
        		
			sfld.x = 10;
			sfld.y = 10;
			sfld.width = sw / 2;
			sfld.height = 50;
			sfld.textColor = 0xFFFFFF;
			sfld.mouseEnabled = false;
			sfld.text = "SCORE : 0000000\nPRESS ANY KEY TO PLAY!\n← LEFT | RIGHT →";
			addChild(sfld);
        }
    }
}