/**
 * Copyright nicoptere ( http://wonderfl.net/user/nicoptere )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/1xi4
 */

package 
{
	import com.bit101.components.HUISlider;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.geom.Point;
	
	/**
	 * @author Nicolas Barradeau
	 * http://en.nicoptere.net
	 */
	public class Proximity extends Sprite 
	{
		private var points:Vector.<Point> = Vector.<Point>([ new Point(297.48,180.02),new Point(302.56,145.32),new Point(283.75,88.31),new Point(237.16,66.59),new Point(198.93,78.66),new Point(184.90,103.70),new Point(193.26,129.34),new Point(201.62,152.56),new Point(195.35,169.76),new Point(179.52,176.70),new Point(158.32,165.23),new Point(148.46,132.35),new Point(175.64,75.64),new Point(249.40,50.90),new Point(334.51,84.99),new Point(354.52,140.20),new Point(345.56,182.73),new Point(310.92,233.71),new Point(261.05,299.77),new Point(250.00,352.87),new Point(238.35,352.87),new Point(247.31,294.04),new Point(275.68,228.88),new Point(246.12,450.90),new Point(224.02,441.86),new Point(214.76,419.53),new Point(224.02,397.21),new Point(246.12,387.86),new Point(268.52,397.21),new Point(277.47,419.53),new Point(268.22,441.86)]);
		private var distanceSlider:HUISlider;
		private var minDist:Number;
		
		public function Proximity() 
		{
			distanceSlider = new HUISlider( this, 10, 10, 'distance', onDistanceChange );
			distanceSlider.value = 32;
			minDist = distanceSlider.value * distanceSlider.value;
			redraw();
		}
		
		private function onDistanceChange( e:Event ):void 
		{
			//square distance is cheaper in computation
			minDist = distanceSlider.value * distanceSlider.value;
			redraw();
		}
		
		private function redraw():void 
		{
			graphics.clear();
			graphics.lineStyle( 0 );
			
			var p:Point, pp:Point;
			for each( p in points )
			{
				for each( pp in points )
				{
					//no use computing the distance to the same point
					if ( p === pp ) continue;
					
					//if ( inlined squared distance computation ) < ( minimum squared distance )
					if ( ( ( p.x - pp.x ) * ( p.x - pp.x ) + ( p.y - pp.y ) * ( p.y - pp.y ) ) < minDist )
					{
						//we should join the dots
						graphics.moveTo( p.x, p.y );
						graphics.lineTo( pp.x, pp.y );
					}
				}
			}
		}
	}
}