/**
 * Copyright SIHO ( http://wonderfl.net/user/SIHO )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/1xQa
 */

// forked from paq's flash on 2010-3-2
package 
{
	import Box2D.Common.Math.b2Vec2;
	import Box2D.Dynamics.b2Body;
	import com.actionsnippet.qbox.QuickBox2D;
	import flash.display.MovieClip;
	import flash.events.Event;
	import flash.events.MouseEvent;
	
	/**
	 * クリック箇所を中心点として、ボールはそこを基点に四方に広がる。
	 * @author SIHO
	 */
	[SWF(backgroundColor="0xFFFFFF", width=465, height=465, frameRate=60)]
	public class Main extends MovieClip 
	{
		private var _qbox:QuickBox2D;
		private var _fixedPoint:b2Vec2 = new b2Vec2(7.75, 7.75);
		private var _objDataArray:Array = [{x:10, y:10,radius:1},{x:7, y:3,radius:1},{x:3, y:7,radius:1}];
		private var objArray:Array = [];
		public function Main():void 
		{
			if (stage) init();
			else addEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		private function init(e:Event = null):void 
		{
			removeEventListener(Event.ADDED_TO_STAGE, init);
			build2D();
			stage.addEventListener(MouseEvent.MOUSE_DOWN,onMouseDown);
		}
		private function build2D():void{
			_qbox = new QuickBox2D(this, { gravityY:0 } );
			_qbox.createStageWalls();
			
			objArray[0] = _qbox.addCircle( _objDataArray[0]);
			objArray[1] = _qbox.addCircle( _objDataArray[1] );
			objArray[2] = _qbox.addCircle( _objDataArray[2] );
			_qbox.start();
			
			addEventListener(Event.ENTER_FRAME, loop);
			}
		
		private function onMouseDown(e:MouseEvent):void 
		{
			objArray[0].destroy();
			objArray[1].destroy();
			objArray[2].destroy();
			_fixedPoint = new b2Vec2(mouseX/30, mouseY/30);
			build2D();
		}
		
		private function loop(e:Event):void 
		{
			//ここ重要----------------------------------------
			for (var body:b2Body = _qbox.w.m_bodyList; body ; body = body.GetNext())
			{
				if (body.IsSleeping())continue;
				
				var f:b2Vec2 = _fixedPoint.Copy();
				f.Subtract(body.GetPosition());
				f.Normalize();
				f.Multiply(80);
				f = f.Negative();
				body.ApplyForce(f, body.GetWorldCenter());
			}
			//----------------------------------------
		}
		
	}
	
}