/**
 * Copyright fluxus ( http://wonderfl.net/user/fluxus )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/1xHS
 */

// forked from fluxus's forked from: forked from: forked from: forked from: forked from: forked from: [ひよこの会] ボタン・クラス
// forked from fluxus's forked from: forked from: forked from: forked from: forked from: [ひよこの会] ボタン・クラス
// forked from fluxus's forked from: forked from: forked from: forked from: [ひよこの会] ボタン・クラス
// forked from fluxus's forked from: forked from: forked from: [ひよこの会] ボタン・クラス
// forked from fluxus's forked from: forked from: [ひよこの会] ボタン・クラス
// forked from fluxus's forked from: [ひよこの会] ボタン・クラス
// forked from ProjectNya's [ひよこの会] ボタン・クラス
////////////////////////////////////////////////////////////////////////////////
// [ひよこの会] ボタン・クラス
// http://www.project-nya.jp/modules/weblog/details.php?blog_id=1245
////////////////////////////////////////////////////////////////////////////////

package {

    import flash.display.Sprite;
    import flash.geom.Rectangle;
    import flash.events.MouseEvent;

    [SWF(backgroundColor="#000000", width="80", height="80", frameRate="500")]

    public class Main extends Sprite {
        private var menus:Array;
        private static var max:uint = 1;

        public function Main() {
            //Wonderfl.capture_delay(1);
            init();
        }

        private function init():void {
            var tile:BitmapTile = new BitmapTile(80, 80, Tile6, 0x000000);
            addChild(tile);
            //
            menus = new Array();
            for (var n:uint = 0; n < max; n++) {
                var menu:ActionBtn = new ActionBtn();
                menu.x = 52 + 90*(n%5);
                menu.y = 40 + 42*uint(n/5);
                addChild(menu);
                menu.init({id: n, label: "photographs"+n, width: 53});
                menu.addEventListener(MouseEvent.CLICK, select, false, 0,true);
                menus.push(menu);
            }
        }
        private function select(evt:MouseEvent):void {
            trace(evt.target.id);
            for (var n:uint = 0; n < menus.length; n++) {
                var menu:ActionBtn = menus[n];
                if (n == evt.target.id) {
                    menu.selected = true;
                } else {
                    menu.selected = false;
                }
            }
        }

    }

}


//////////////////////////////////////////////////
// ActionBtnクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.display.Shape;
import flash.text.TextField;
import flash.text.TextFieldType;
import flash.text.AntiAliasType;
import flash.text.TextFormat;
import flash.text.TextFormatAlign;
import flash.filters.DropShadowFilter;
import flash.geom.Matrix;
import flash.display.GradientType;
import flash.display.SpreadMethod;
import flash.display.InterpolationMethod;
import flash.geom.ColorTransform;
import flash.events.Event;
import flash.events.MouseEvent;

class ActionBtn extends Sprite {
    public var id:uint;
    private var shade:Shape;
    private var base:Shape;
    private var front:Shape;
    private var light:Shape;
    private var overlay:Shape;
    private var txt:TextField;
    private var label:String = "";
    private static var fontType:String = "_Microsoft Yi Baiti";
    private var _width:uint = 60;
    private static var _height:uint = 25;
    private static var corner:uint = 1;
    private static var tHeight:uint = 15;
    private static var bColor:uint = 0x000000;
    private static var sColor:uint = 0x000000;
    private static var baseColor:uint = 0x000000;
    private static var lightColor:uint = 0xFFFFFF;
    private static var overColor:uint = 0xFFFFFF;
    private static var tColor:uint = 0xFFFFFF;
    private static var defaultColorTrans:ColorTransform;
    private static var disableColor:uint = 0xCCCCCC;
    private static var disableColorTrans:ColorTransform;
    private var mode:int;
    private var _selected:Boolean = false;
    private var _enabled:Boolean = true;

    public function ActionBtn() {
    }

    public function init(option:Object):void {
        if (option.id != undefined) id = option.id;
        if (option.label != undefined) label = option.label;
        if (option.width != undefined) _width = option.width;
        draw();
    }
    private function draw():void {
        defaultColorTrans = new ColorTransform();
        disableColorTrans = new ColorTransform();
        disableColorTrans.color = disableColor;
        shade = new Shape();
        base = new Shape();
        front = new Shape();
        light = new Shape();
        overlay = new Shape();
        txt = new TextField();
        addChild(shade);
        addChild(base);
        addChild(front);
        addChild(light);
        addChild(overlay);
        addChild(txt);
        createBase(shade, _width, _height, corner, bColor);
        shade.filters = [new DropShadowFilter(1, 90, sColor, 0.4, 4, 4, 2, 3, false, false)];
        createBase(base, _width-2, _height-2, corner, baseColor);
        createFront(front, _width, _height, corner);
        createLight(light, _width-2, _height-2, corner);
        createOverlay(overlay, _width-2, _height-2, corner);
        txt.x = -_width/2;
        txt.y = -tHeight + _height/4;
        txt.width = _width;
        txt.height = tHeight;
        txt.type = TextFieldType.DYNAMIC;
        txt.selectable = false;
        //txt.embedFonts = true;
        //txt.antiAliasType = AntiAliasType.ADVANCED;
        var tf:TextFormat = new TextFormat();
        tf.font = fontType;
        tf.size = 10;
        tf.align = TextFormatAlign.CENTER;
        txt.defaultTextFormat = tf;
        txt.textColor = tColor;
        txt.text = label;
        txt.filters = [new DropShadowFilter(0, 90, sColor, 0.5, 2, 2, 2, 3, false, false)];
        light.alpha = 0;
        enabled = true;
        mouseChildren = false;
    }
    private function rollOver(evt:MouseEvent = null):void {
        mode = 1;
        addEventListener(Event.ENTER_FRAME, action, false, 0, true);
    }
    private function rollOut(evt:MouseEvent = null):void {
        mode = -1;
        addEventListener(Event.ENTER_FRAME, action, false, 0, true);
    }
    private function action(evt:Event):void {
        light.alpha += 0.1*mode;
        if (light.alpha < 0) {
            light.alpha = 0;
            removeEventListener(Event.ENTER_FRAME, action);
        }
        if (light.alpha > 1) {
            light.alpha = 1;
            removeEventListener(Event.ENTER_FRAME, action);
        }
    }
    private function _up():void {
        base.transform.colorTransform = defaultColorTrans;
        front.transform.colorTransform = defaultColorTrans;
    }
    private function _down():void {
        base.transform.colorTransform = defaultColorTrans;
        front.transform.colorTransform = defaultColorTrans;
        light.alpha = 1;
    }
    private function _disable():void {
        base.transform.colorTransform = disableColorTrans;
        front.transform.colorTransform = disableColorTrans;
    }
    public function get selected():Boolean {
        return _selected;
    }
    public function set selected(param:Boolean):void {
        _selected = param;
        enabled = !_selected;
        if (_selected) {
            _down();
        } else {
            _up();
            rollOut();
        }
    }
    public function get enabled():Boolean {
        return _enabled;
    }
    public function set enabled(param:Boolean):void {
        _enabled = param;
        buttonMode = _enabled;
        mouseEnabled = _enabled;
        useHandCursor = _enabled;
        if (_enabled) {
            _up();
            addEventListener(MouseEvent.MOUSE_OVER, rollOver, false, 0, true);
            addEventListener(MouseEvent.MOUSE_OUT, rollOut, false, 0, true);
        } else {
            _disable();
            removeEventListener(MouseEvent.MOUSE_OVER, rollOver);
            removeEventListener(MouseEvent.MOUSE_OUT, rollOut);
        }
    }
    private function createBase(target:Shape, w:uint, h:uint, c:uint, color:uint, alpha:Number = 1):void {
        target.graphics.beginFill(color, alpha);
        target.graphics.drawRoundRect(-w/2, -h/2, w, h, c*2);
        target.graphics.endFill();
    }
    private function createFront(target:Shape, w:uint, h:uint, c:uint):void {
        var colors:Array = [baseColor, baseColor];
        var alphas:Array = [0, 0.5];
        var ratios:Array = [0, 255];
        var matrix:Matrix = new Matrix();
        matrix.createGradientBox(w, h, 0.5*Math.PI, -w/2, -h/2);
        target.graphics.beginGradientFill(GradientType.LINEAR, colors, alphas, ratios, matrix, SpreadMethod.PAD, InterpolationMethod.RGB, 0);
        target.graphics.drawRoundRect(-w/2, -h/2, w, h, c*2);
        target.graphics.endFill();
    }
    private function createLight(target:Shape, w:uint, h:uint, c:uint):void {
        var colors:Array = [lightColor, overColor];
        var alphas:Array = [1, 0];
        var ratios:Array = [40, 160];
        var matrix:Matrix = new Matrix();
        matrix.createGradientBox(w*2, h*3, 0, -w, -h*0.9);
        target.graphics.beginGradientFill(GradientType.RADIAL, colors, alphas, ratios, matrix, SpreadMethod.PAD, InterpolationMethod.RGB, 0);
        target.graphics.drawRoundRect(-w/2, -h/2, w, h, c*2);
        target.graphics.endFill();
    }
    private function createOverlay(target:Shape, w:uint, h:uint, c:uint):void {
        target.graphics.beginFill(bColor, 0.3);
        target.graphics.drawEllipse(-w*1.125, -h*4.375, w*2.25, h*4.375);
        target.graphics.endFill();
        var _mask:Shape = new Shape();
        _mask.graphics.beginFill(sColor);
        _mask.graphics.drawRoundRect(-w/2, -h/2, w, h, c*2);
        _mask.graphics.endFill();
        addChild(_mask);
        target.mask = _mask;
    }

}


//////////////////////////////////////////////////
// BitmapTileクラス
//////////////////////////////////////////////////

import flash.display.Shape;
import flash.display.BitmapData;
import flash.geom.ColorTransform;

class BitmapTile extends Shape {
    private var _width:uint;
    private var _height:uint;

    public function BitmapTile(w:uint, h:uint, Tile:Class, color:uint = 0x000000) {
        _width = w;
        _height = h;
        draw(Tile, color);
    }

    private function draw(Tile:Class, color:uint):void {
        var tile:BitmapData = new Tile();
        var bitmapdata:BitmapData = new BitmapData(tile.width, tile.height);
        var colorTrans:ColorTransform = new ColorTransform();
        colorTrans.color = color;
        bitmapdata.draw(tile, null, colorTrans);
        graphics.beginBitmapFill(bitmapdata, null, true);
        graphics.drawRect(0, 0, _width, _height);
        graphics.endFill();
    }

}


import flash.display.BitmapData;

class Tile6 extends BitmapData {
    private static var size:uint = 6;
    private static var color:uint = 0x00000000;

    public function Tile6() {
        super(size, size, true, 0x00000000);
        init();
    }

    private function init():void {
        setPixel32(0, 2, color);
        setPixel32(0, 5, color);
        setPixel32(1, 1, color);
        setPixel32(1, 4, color);
        setPixel32(2, 0, color);
        setPixel32(2, 3, color);
        setPixel32(3, 2, color);
        setPixel32(3, 5, color);
        setPixel32(4, 1, color);
        setPixel32(4, 4, color);
        setPixel32(5, 0, color);
        setPixel32(5, 3, color);
    }

}
