/**
 * Copyright Scmiz ( http://wonderfl.net/user/Scmiz )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/1wmP
 */

package {
    import flash.display.Sprite;
	import flash.events.KeyboardEvent;
	import flash.ui.Keyboard;
    public class FlashTest extends Sprite {
		private var gridSize:uint = 20;
		private var padding:uint = 8;
		
        public function FlashTest() {
			draw();
			
			stage.addEventListener(KeyboardEvent.KEY_DOWN, onDown);
        }
		
		private function draw():void {
			this.graphics.clear();
			
			this.graphics.beginFill(0x808080);
			this.graphics.drawRect(0, 0, 465, 465);
			this.graphics.endFill();
			
			var radius:Number = padding * 1.414 * 0.5;
			
			var num:uint = 600 / (gridSize + padding);

			var basePosX:Number = 232.5 - ((gridSize + padding) * (num / 2)) - (padding / 2);
			var basePosY:Number = 232.5 - ((gridSize + padding) * (num / 2)) - (padding / 2);
			for (var y:uint = 0; y < num; ++y) {
				for (var x:uint = 0; x < num; ++x) {
					var posX:Number = basePosX + (x * (gridSize + padding));
					var posY:Number = basePosY + (y * (gridSize + padding));
					
					this.graphics.beginFill(0x000000);
					this.graphics.drawRect(posX, posY, gridSize, gridSize);
					this.graphics.endFill();
					
					this.graphics.beginFill(0xffffff);
					this.graphics.drawCircle(posX + gridSize + (padding / 2), posY + gridSize + (padding / 2), radius);
					this.graphics.endFill();
				}
			}
		}
		
		private function onDown(e:KeyboardEvent):void {
			if (e.keyCode == Keyboard.UP) {
				if (gridSize < 40) {
					++gridSize;
					draw();
				}
			}
			else if (e.keyCode == Keyboard.DOWN) {
				if (gridSize > 2) {
					--gridSize;
					draw();
				}
			}
			else if (e.keyCode == Keyboard.LEFT) {
				if (padding > 2) {
					--padding;
					draw();
				}
			}
			else if (e.keyCode == Keyboard.RIGHT) {
				if (padding < 40) {
					++padding;
					draw();
				}
			}
		}
    }
}