/**
 * Copyright uwi ( http://wonderfl.net/user/uwi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/1wWV
 */

package {
    import flash.display.Sprite;
    import flash.text.TextField;
    import flash.utils.getTimer;
    // @see http://projecteuler.net/index.php?section=problems&id=
    public class Euler extends Sprite {
        private var _tf : TextField;
  
        public function Euler() {
            _tf = new TextField();
            _tf.width = 465;
            _tf.height = 465;
            addChild(_tf);
            
            var s : int = getTimer();
            _tf.appendText("" + solve() + "\n");
            var g : int = getTimer();
            _tf.appendText("" + (g - s) + " ms\n");
        }
        
        private var N : int = 200000;
        
        private function solve() : int
        {
            var primes : Array = doEratosthenes(N);
            
            var i : int;
            var ct : int = 0;
            var sum : int = 0;
            for each(var p : int in primes){
                if(p <= 5)continue;
                var hp : int = p / 2 + 1;
                for(var v : int = 0, r : int = 0;;){
                    v = int(int(v * 10) + 1) % p;
                    r++;
                    if(r > hp){
                        r = p - 1;
                        break;
                    }
                    if(v == 0)break;
                }
                var q : int = r;
                for(i = 0;i < 9 && q % 2 == 0;i++, q >>>= 1);
                for(i = 0;i < 9 && q % 5 == 0;i++, q /= 5);
                if(q == 1){
                    _tf.appendText("" + p + "\t" + r + "\n");
                    ct++;
                    sum += p;
                    if(ct == 40)break;
                }
            }
            _tf.appendText("ct : " + ct + "\n");
            return sum;
        }
        
        private static function doEratosthenes(n : int) : Array
        {
            var ar : Vector.<uint> = new Vector.<uint>(n / 2 - 1);
            var i : int;
            for(i = 0;i < ar.length;i++)ar[i] = 1;
            
            var sq : int = (Math.sqrt(n) - 3) >> 1;
            for(var p : int = 0;p <= sq;p++){
                if(ar[p] == 1){
                    var m : int = 2 * p + 3;
                    for(var mm : int = m * m;mm <= n;mm += 2 * m){
                        ar[(mm - 3) >> 1] = 0;
                    }
                }
            }
            var ret : Array = [2];
            for(i = 0;i < ar.length;i++){
                if(ar[i] == 1)ret.push(2 * i + 3);
            }
            return ret;
        }    }
}