/**
 * Copyright Nyarineko ( http://wonderfl.net/user/Nyarineko )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/1wUG
 */

package 
{
	import flash.events.*;
	import org.papervision3d.view.BasicView;
	import org.papervision3d.view.*;
	import org.papervision3d.objects.*;
	import org.papervision3d.core.geom.renderables.Vertex3D;
	
    [SWF(width = "465", height = "465", backgroundColor = "0x000000")]
	public class Mesh extends BasicView
	{
		public var _list:Array;
		public var _num:uint = 0;
		public var _lng:uint = 60;
		
		function Mesh():void
		{
			super(0, 0, true, true);
			stage.frameRate = 60;
			
			_list = [];
			for(var i:Number = 0; i < _lng; i++){
				_list[i] = new Particle(new Vertex3D( 0,0,0 ),new Vertex3D( 0,0,0 ),new Vertex3D( 0,0,0 ));
				scene.addChild(_list[i].mesh);
			}
            stage.addEventListener(MouseEvent.MOUSE_MOVE, _move);
			startRendering();
		}
		
		private function _move(e:MouseEvent = null):void
		{
			var _numR:uint = _num - 1;
			if(_num == 0) _numR = _lng - 1;
			scene.removeChild(_list[_num].mesh);
			var v: Vertex3D = new Vertex3D( (mouseX - stage.stageWidth / 2) * 2,(-mouseY + stage.stageHeight / 2) * 2,-100 -Math.random()*200 );
			_list[_num] = new Particle(_list[_numR].v1,_list[_numR].v2,v);
			scene.addChild(_list[_num].mesh);
			_num++;
			if(_num == _lng) _num = 0;
		}
		
		override protected function onRenderTick(event:Event=null):void
		{
			renderer.renderScene(scene, camera, viewport);
		}
	}
	
}

import org.papervision3d.lights.PointLight3D;
import org.papervision3d.view.*;
import org.papervision3d.materials.*;
import org.papervision3d.materials.shadematerials.FlatShadeMaterial;
import org.papervision3d.core.geom.*;
import org.papervision3d.objects.*;
import org.papervision3d.core.geom.renderables.Vertex3D;
import org.papervision3d.core.math.NumberUV;
import org.papervision3d.core.geom.renderables.Triangle3D;
import org.libspark.betweenas3.BetweenAS3;
import org.libspark.betweenas3.easing.*;
import org.libspark.betweenas3.tweens.ITween;

class Particle
{
    public var x:Number;
	public var _v0: Vertex3D;
	public var _v1: Vertex3D;
	public var _v2: Vertex3D;
	public var mesh:TriangleMesh3D;
	public var _next: Vertex3D;
    
    public function Particle(v0:Vertex3D,v1:Vertex3D,v2:Vertex3D):void
    {
		_v0 = v0;
		_v1 = v1;
		_v2 = v2;
		
		var light:PointLight3D = new PointLight3D();
		var matFSM:FlatShadeMaterial = new FlatShadeMaterial(light, 0x222222, 0xff3366);
		matFSM.doubleSided = true;
		mesh = new TriangleMesh3D( matFSM , new Array(), new Array(), null );
		mesh.geometry.vertices = [ v0 , v1 , v2 ];
		mesh.geometry.faces.push( new Triangle3D( mesh, new Array(v0,v1,v2), null, new Array(new NumberUV( 0, 0 ),new NumberUV( 1, 0 ),new NumberUV( 0, 1 )) ));
		mesh.geometry.ready = true;
		for each(var obj:* in mesh.geometry.vertices){
			BetweenAS3.parallel(
			BetweenAS3.tween(obj,{x:obj.x+(Math.random()*100 - 50)},null,5,Sine.easeIn),
			BetweenAS3.tween(obj,{y:obj.y+(Math.random()*100 - 50)},null,5,Sine.easeIn),
			BetweenAS3.tween(obj,{z:obj.z+(Math.random()*100 - 50)},null,5,Sine.easeIn)).play();
		}
    }
	public function get v0():Vertex3D{
		return _v0;
	}
	public function get v1():Vertex3D{
		return _v1;
	}
	public function get v2():Vertex3D{
		return _v2;
	}
}