/**
 * Copyright marcsali ( http://wonderfl.net/user/marcsali )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/1w1u
 */

// forked from mash's wonderFl_KeyVisual_v3 with explanation 
// 
//　-- welcome to wonderfl -- 
// 
// wonderflは、サイト上でFlashをつくることのできるサービス。 
// 
// サイトにあるフォームにActionscript3のコードを書き、 
// サーバサイドでコンパイルを行います。 
// コンパイル結果がページ上に自動的に表示されるので、 
// 完成したFlashをリアルタイムに見ながらコードを書くことができます。 
// 
// まずは、Fork ボタンをクリックして、このソースを改造してみよう。 
// 
// forked from Murai's wonderFl_KeyVisual_v3 
package  
{ 
     
    /** 
     *  
     * @author Takashi Murai(KAYAC) 
     */ 
      
    import flash.display.* 
    import flash.events.* 
    import flash.text.* 
    import flash.filters.*; 
    import flash.geom.*; 
    import flash.utils.* 
     
    [SWF(width="465", height="465", backgroundColor="0x000000", frameRate="15")] 
     
    public class WonderFL extends MovieClip { 
        // 
        private var txtLayer:Sprite=new Sprite() 
        private var drawPos:Sprite=new Sprite() 
        private var textPos:Sprite=new Sprite() 
         
        private var txtFmt:TextFormat = new TextFormat(); 
        private var textFields:TextField=new TextField() 
         
        //message 
        private var messages :Array =[ 
            "<_<_<_<__write code__________", 
            "_<_<_<_<_write code__________", 
            "<_<_<_<__write code__________", 
            "_<_<_<_<_write code__________", 
            "<_<_<_<__write code__________", 
            "_<_<_<_<_write code__________", 
            "<_<_<_<__write code__________", 
            "_<_<_<_<_write code__________", 
            "<_<_<_<__write code__________", 
            "_<_<_<_<_write code__________", 
            "<_<_<_<__write code__________", 
            "_<_<_<_<_write code__________",     
            "<_<_<_<__write code__________", 
            "_<_<_<_<_write code__________", 
            "<_<_<_<__write code__________", 
            "_<_<_<_<_write code__________", 
            "<_<_<_<__write code__________", 
            "_<_<_<_<_write code__________", 
            "<_<_<_<__write code__________", 
            "_<_<_<_<_write code__________", 
            "<_<_<_<__write code__________", 
            "_<_<_<_<_write code__________", 
            "<_<_<_<__write code__________", 
            "_<_<_<_<_write code__________",     
            "We watch you.", 
            "e watch you.!", 
            "e watch you..", 
            "e watch you.!", 
            "e watch you..", 
            "e watch you.!", 
            "e watch you..", 
            "e watch you.!", 
            "e watch you." 
        ] 
         
        //lleasures 
        private var posX:Number = 30 
        private var posY:Number = stage.stageHeight/2 
        private var disX:Number = 40 
        private var disY:Number = 5 
        private var deg:Number = 0 
        private var count:Number = 0;   
        private var step:Number =2 
        private var cx:Number = stage.stageWidth /2 
        private var cy:Number = stage.stageHeight /2 
        private var xPos:Number = 0 
        private var yPos:Number = 0 
         
        //gladationLine 
        private var mtx :Matrix = new Matrix(); 
        private var gradCount :Number =1 
        private var gradDir :Number =1 
        private var life :Number =0 
        private var lifeLmt :Number =100 
         
        //fader 
        private var blurVall :Number =4 
        private var faderAlpha :Number =0.8 
        private var interval :Number =100 
        private var _bdTxt:BitmapData 
        private var _bmpTxt:Bitmap 
        private var _bdLine:BitmapData 
        private var _bmpLine:Bitmap 
        private var _blurF:BlurFilter 
         
        public function WonderFL() {  
            init() 
             
            initFader() 
             
            this.addChild(_bmpLine) 
            this.addChild(_bmpTxt) 
            txtLayer.addChild(textPos) 
            textPos.addChild(textFields) 
        } 
         
        private function init() :void { 
            initLissajous() 
            setMessage("","normal",0xFFFFFF) 
             faderAlpha=0.9 
             
            var timerLmt :Number =(messages.length-1) 
            var phaseCnt :Number =0 
            var phase1:Timer = new Timer(interval, timerLmt); 
            phase1.addEventListener(TimerEvent.TIMER, function(e:Event) :void { 
                setMessage(messages[phaseCnt++],"normal",0xFF0000) 
            }); 
            phase1.start();  
             
            var phase2:Timer = new Timer((timerLmt)*interval+1500, 1); 
            phase2.addEventListener(TimerEvent.TIMER_COMPLETE, function(e:Event) :void { 
                setMessage(messages[messages.length-1],"normal",0xFFFFFF) 
                startLissajous() 
                faderAlpha=0.999 
            }); 
            phase2.start();  
             
            var phase3:Timer = new Timer((timerLmt)*interval+1500+10000, 1); 
            phase3.addEventListener(TimerEvent.TIMER_COMPLETE, function(e:Event) :void { 
                reset() 
            }); 
            phase3.start();  
        } 
         
        private function reset() :void { 
            stage.removeEventListener(Event.ENTER_FRAME, drawLissajous);   
            init() 
        } 
         
        private function setMessage(mes:String,blend:String,hex:Number) :void { 
            txtFmt.font="Arial" 
            txtFmt.align = TextFormatAlign.CENTER; 
            txtFmt.color=hex 
            txtFmt.size=30 
             
            textFields.defaultTextFormat = txtFmt; 
            textFields.multiline=true 
            textFields.autoSize=TextFieldAutoSize.LEFT 
            textFields.x =0 
            textFields.y = 0 
            textFields.text=mes 
             
             
            textPos.alpha=0.5 
            textPos.blendMode=blend 
             
            textPos.x=stage.stageWidth/2-textFields.width/2 
            textPos.y=stage.stageHeight/2-textFields.height/2 
        } 

        private function initFader() :void { 
             
            _bdTxt=new BitmapData(stage.stageWidth,stage.stageHeight,true,0x000000); 
            _bmpTxt=new  Bitmap(_bdTxt); 
            _blurF=new BlurFilter(blurVall,blurVall,3); 
             
            _bdLine=new BitmapData(stage.stageWidth,stage.stageHeight,true,0x000000); 
            _bmpLine=new  Bitmap(_bdLine); 
            _blurF=new BlurFilter(blurVall,blurVall,3); 
             
             stage.addEventListener(Event.ENTER_FRAME, render);   
        } 
         
        private function render(e:Event):void { 
            _bdLine.colorTransform(_bdLine.rect, new ColorTransform(1, 1, 1,faderAlpha, 0, 0, 0, 0)); 
            _bdLine.applyFilter(_bdLine,_bdLine.rect,new Point(0,0),_blurF); 
            _bdTxt.colorTransform(_bdTxt.rect, new ColorTransform(1, 1, 1,0.9, 0, 0, 0, 0)); 
            _bdTxt.applyFilter(_bdTxt,_bdTxt.rect,new Point(0,0),_blurF); 
             
            _bdLine.scroll(8,0) 
             
            _bdLine.draw(drawPos); 
            _bdTxt.draw(txtLayer); 
        } 
         
        private function initLissajous() :void { 
            mtx.createGradientBox(400, 400, 0, 0, 0); 
            drawPos.graphics.clear() 
            drawPos.graphics.lineStyle(4);   
            drawPos.graphics.lineGradientStyle(GradientType.LINEAR,  [0xFF0000, 0x0000FF], [1,0.2],[gradCount,255-gradCount], mtx, SpreadMethod.REFLECT); 
            drawPos.graphics.moveTo(xPos,yPos);   
        } 
         
        private function startLissajous() :void { 
             stage.addEventListener(Event.ENTER_FRAME, drawLissajous);   
        } 
         
        private function drawLissajous(e:Event):void { 
             count+= step;   
             xPos = posX * Math.sin(disX * count + deg) 
             yPos = (posY) * Math.sin(disY * count) + cy 
             if(gradCount>=255 || 0>=gradCount){ 
                gradDir*=-1 
            } 
            gradCount+=gradDir 
            life=life>lifeLmt?0:life+1 
            if (life>lifeLmt) { 
                drawPos.graphics.clear() 
                drawPos.graphics.lineStyle(1);   
                drawPos.graphics.moveTo(xPos,yPos) 
            } 

            drawPos.graphics.lineGradientStyle(GradientType.LINEAR,  [0xFF0000, 0x0000FF], [(gradCount/255),((255-gradCount)/255)],[1,255], mtx, SpreadMethod.REFLECT); 
            drawPos.graphics.lineTo(xPos,yPos);   
        } 
    } 
} 
