/**
 * Copyright mitien ( http://wonderfl.net/user/mitien )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/1uyn
 */

// forked from mousepancyo's Particle Light（StarDust）
// forked from otherone's StarDustテスト
package {
    import flash.display.*;
    import flash.events.Event;
    import flash.filters.GlowFilter;
    import flash.geom.Rectangle;
    import flash.geom.ColorTransform;
    import flash.geom.Point;
    import flash.filters.BlurFilter;
    import net.hires.debug.Stats;
    import idv.cjcat.stardust.common.clocks.SteadyClock;
    import idv.cjcat.stardust.common.emitters.Emitter;
    import idv.cjcat.stardust.common.renderers.Renderer;
    import idv.cjcat.stardust.twoD.renderers.BitmapRenderer;
    import frocessing.color.ColorHSV;

    [SWF(width = 465,height = 465,frameRate = 31,backgroundColor = 0)]
    
    public class Main extends Sprite {
        protected var emitter:Emitter;// эмитер
        protected var renderer:Renderer;// рендерер
        private const stw:uint = stage.stageWidth,sth:uint = stage.stageHeight;
        private var _hsv:ColorHSV;
        private var _bmd:BitmapData;
        private var _blurBmd:BitmapData;
        private var _ctf:ColorTransform;
        
        public function Main() {
            _hsv = new ColorHSV(0, .8, .95);
            _bmd = new BitmapData(465, 465, false, 0);
            _ctf = new ColorTransform(.95, .9, .7);
            //
            var bm:Bitmap = new Bitmap(_bmd);
            var bbm:Bitmap = new Bitmap(_blurBmd = _bmd.clone());
            bbm.blendMode = "add"
            addChild(bm)
            addChild(bbm)
            addChild(new Stats());
            //
            // Строительство частиц
            //
            // [1]clock созданны 
            // [2]излучатель создан
            emitter = new MyEmitter(new SteadyClock(6)); //указание сколько эмитеров в кадре
            // [3]создание визуализации (MC указан)
            renderer = new BitmapRenderer(_bmd);
            // [4]добавить эмитер в визуализацию
            renderer.addEmitter(emitter);
            //
            addEventListener(Event.ENTER_FRAME, loop);
        }
            
        private function loop(e:Event):void {
            _ctf.redMultiplier = (_hsv.value >> 16 & 0xff) / 255;
            _ctf.greenMultiplier = (_hsv.value >> 8 & 0xff) / 255;
            _ctf.blueMultiplier = (_hsv.value & 0xff) / 255
            //
            _bmd.colorTransform(_bmd.rect, _ctf)
            _bmd.applyFilter(_bmd, _bmd.rect, new Point(), new BlurFilter(4, 4, 3))
            _blurBmd.copyPixels(_bmd, _bmd.rect, new Point())
            //
            MyEmitter(emitter).point.x += (mouseX - MyEmitter(emitter).point.x) * .1;
            MyEmitter(emitter).point.y += (mouseY - MyEmitter(emitter).point.y) * .1;
            //
            _hsv.h++;
            emitter.step();
        }

    }
}

//Эмиттер
import idv.cjcat.stardust.common.actions.*;
import idv.cjcat.stardust.common.clocks.*;
import idv.cjcat.stardust.common.initializers.*;
import idv.cjcat.stardust.common.math.*;
import idv.cjcat.stardust.twoD.actions.*;
import idv.cjcat.stardust.twoD.emitters.*;
import idv.cjcat.stardust.twoD.initializers.*;
import idv.cjcat.stardust.twoD.zones.*;
import idv.cjcat.stardust.twoD.renderers.*;
import idv.cjcat.stardust.twoD.fields.BitmapField;
import idv.cjcat.stardust.twoD.fields.UniformField;

class MyEmitter extends Emitter2D {
    public var point:SinglePoint = new SinglePoint(); // Позиция частиц
    
    public function MyEmitter(clock:Clock = null) {
        //-- Строительство частиц
        super(clock);
        // [5] Для инициализации;
        // Укажите, какие элементы частиц
        addInitializer(new DisplayObjectClass(MyCircle));
        // Учитывая сила, приложенная к частице;
        addInitializer(new Velocity(new LazySectorZone(0.1, 0)));
        // Частица жизни (выживания) задается
        addInitializer(new Life(new UniformRandom(40, 20)));
        addInitializer(new Position(point));        

        // [6] На решение
        addAction(new AlphaCurve(20,40));
        
        addAction(new Age());   //Жизнь;
        addAction(new DeathLife());    // Смерть;
        addAction(new Accelerate(0.05)); // Ускорение;
        addAction(new Move()); //движение;
        
        var bmpField:BitmapField = new BitmapField();
        bmpField.max = 0.1;
        bmpField.massless = false;
        bmpField.scaleX = bmpField.scaleY = 0;
        
        // гравитация;
        var gravity:Gravity = new Gravity();
        gravity.addField(bmpField);
        gravity.addField(new UniformField( 0, 0.01)); // x , y
        addAction(gravity);
    }
}

import flash.display.Shape;
class MyCircle extends Shape {
    public function MyCircle() {
        graphics.beginFill (0xFFFFFF,1.0);
        graphics.drawCircle(0, 0, Math.random()*5 | 0);
        graphics.endFill()
    }
}