/**
 * Copyright k3lab ( http://wonderfl.net/user/k3lab )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/1utY
 */

// forked from checkmate's adobe challenge 1
/**
 * 
 * "Use Flash Player 10 drawing API,
 *  specifically drawTriangles.
 *  My favorite part of the new capabilities
 *  is the ability to specify
 *  UVT texture mapping data."
 *                     by Justin Everett-Church
 *  
 * This code is a example of drawTriangle.
 */
package {
    
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    import flash.display.Graphics;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.geom.ColorTransform;
    
    [SWF(width="465", height="465", backgroundColor="0x000000")]

    public class drawTriangleTest extends Sprite{
    
        private var bmpd     :BitmapData;
        private var container:Sprite;
        private var triangle:Sprite;
        private var arcs :Sprite;
        private var shape:Sprite 

        private var verD     :Vector.<Number>;

        private var color:ColorTransform = new ColorTransform(1, 1, 1, 1, -50, -35, -15); 


        public function drawTriangleTest() {

            bmpd = new  BitmapData(465, 465, false,0x0);
            addChild(new Bitmap(bmpd)) as Bitmap;

            container= new Sprite();
            triangle= new Sprite();

            arcs =new Sprite()
            arcs.x = stage.stageWidth/2;
            arcs.y = stage.stageHeight / 2;

            var radin:Number=-60*Math.PI/180
            var xx:Number = -200 + Math.cos(radin) * 400
            var yy:Number = 150 + Math.sin(radin) * 400;

            for (var j:int = 0; j < 5; j++) {
                shape=new Sprite(); 
                shape.graphics.beginFill(0xFF); 
                   verD = Vector.<Number>([xx, yy, -200, 150, 200, 150]); 
                   shape.graphics.drawTriangles(verD); 
                shape.graphics.endFill(); 
                triangle.addChild(shape);
                arcs.addChild(triangle)
            }

            var xPos:Array=[-200,xx,200]
            var yPos:Array = [150, yy, 150]
            var radian:Array =[[ -60, 0],[60,120],[180,240]]
            for (var i:int = 0; i < 3; i++) {
                var _arc:Arc = new Arc(xPos[i], yPos[i],radian[i][0],radian[i][1]);
                _arc.createArc();
                container.addChild(_arc)
                arcs.addChild(container)
            }
		
            addEventListener(Event.ENTER_FRAME, handleEnterFrame);

        } 

        private function handleEnterFrame(e:Event):void{
            triangle.x = stage.stageWidth/2;
            triangle.y = stage.stageHeight/2;
            container.x =  stage.stageWidth/2;
            container.y = stage.stageHeight/2;
            triangle.rotation += 5;
            container.rotation += 365;
            container.blendMode = "add";
            shape.blendMode = "screen";
            bmpd.colorTransform(bmpd.rect, color); 
            bmpd.draw(arcs);
        }

    }
}

import frocessing.display.F5MovieClip2D;
class Arc extends F5MovieClip2D {
    private var _x:Number;
    private var _y:Number;
    private var _srart:Number;
    private var _stop:Number;
    public function Arc (_x:Number, _y:Number,_radianStart:Number,_radianStop:Number):void {
        this._x = _x;
        this._y = _y;
        _srart = _radianStart * Math.PI / 180
        _stop = _radianStop * Math.PI / 180;
    }
    public function createArc():void {
        stroke(0x0)
        fill( 150, 50, 25); 
        arc(_x, _y, 800, 800,_srart,_stop)
    }
}

