/**
 * Copyright yprops ( http://wonderfl.net/user/yprops )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/1uU2
 */

// forked from yprops's テキスト表示用
package
{
    import flash.system.IME;
    import flash.events.*;
    import flash.display.*;
    import flash.text.*;
    
    public class DebugText extends Sprite
    {
        
        
        //------------main-----------------------
        
        
        private var tx :TextField;
        
        public function main() :void{
            this.tabChildren = false;
            addDebLine("テキスト","表示");
            
            tx = new TextField();
            tx.type = TextFieldType.INPUT;
            tx.width = 300;
            tx.height = 30;
            tx.x = 100;
            tx.y = 150;
            tx.border = true;
            tx.background = true;
            tx.restrict = "0-9";
            addChild(tx);
            
            IME.enabled = false;
            tx.addEventListener(MouseEvent.CLICK, onFocusIn);
            tx.addEventListener(FocusEvent.FOCUS_IN, onFocusIn);
            tx.addEventListener(KeyboardEvent.KEY_DOWN, onKeyDown);
            tx.addEventListener(Event.CHANGE, txOnChange);
            tx.addEventListener(TextEvent.TEXT_INPUT, txOnInput);
            
        }
        private function onFocusIn(ev:Event) :void{
            addDebLine("focusin", tx.caretIndex);
        }
        private function onKeyDown(ev:Event) :void{
            addDebLine("keydown", tx.caretIndex);
        }

        private function txOnChange(ev:Event) :void{
            addDebLine("changed", tx.text);
        }
        private function txOnInput(ev:Event) :void{
            addDebLine("input", tx.text);
        }

        
        
        
        //------------general---------------------
        public function DebugText(){
            if(stage)init();
            addEventListener(Event.ADDED_TO_STAGE, init);
        }
        private function init(ev:Event = null) :void{
            removeEventListener(Event.ADDED_TO_STAGE, init);
            addDeb(450, 450);
            main();
        }
        private var deb :TextField;
        private function addDeb(w:uint, h:uint) :void{
                deb = new TextField();
                deb.wordWrap = true;
                deb.width = w;
                deb.height = h;
                deb.border = true;
                deb.borderColor = 0;
                deb.background = true;
                deb.backgroundColor = 0x99ffffff;
                deb.text = "beginDebugText-------\n\n";
                addChild(deb);
        }
        private function addDebLine(...args) :void{
                deb.appendText(args.join(" ") + "\n");
                deb.scrollV = deb.maxScrollV;
        }
    }
}