/**
 * Copyright Yuichi ( http://wonderfl.net/user/Yuichi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/1uJu
 */

package {
    import flash.display.Sprite;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.text.TextField;
    import flash.text.TextFormat;
    import flash.text.TextFieldType;
    import flash.filters.ColorMatrixFilter;
    import flash.filters.ConvolutionFilter;
    import flash.geom.Point;
    import flash.geom.Rectangle;
    import flash.events.Event;
    
    public class Main extends Sprite {
        private var textField:TextField;
        private var tmpTextField:TextField;
        private var canvas:BitmapData;
        private var rect:Rectangle;
        private var point:Point;
        private var grayScaleFilter:ColorMatrixFilter;
        private var laplacianFilter:ConvolutionFilter;
        private var reverseFilter:ColorMatrixFilter;
        
        public function Main():void {
            addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event):void {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            
            //元となるテキスト
            var textFormat:TextFormat = new TextFormat();
            textFormat.size = 60;
            textFormat.color = 0x88aaff;
            
            textField= new TextField();
            textField.defaultTextFormat = textFormat;
            textField.type = TextFieldType.INPUT;
            textField.wordWrap = true;
            textField.multiline = true;
            textField.width = stage.stageWidth;
            textField.height = stage.stageHeight / 2;
            textField.text = "wonderfl\n"+"build flash\n"+"online";
            addChild(textField);
            
            tmpTextField = new TextField();
            tmpTextField.defaultTextFormat = textFormat;
            tmpTextField.type = TextFieldType.DYNAMIC;
            tmpTextField.wordWrap = true;
            tmpTextField.multiline = true;
            tmpTextField.width = stage.stageWidth;
            tmpTextField.height = stage.stageHeight / 2;
            tmpTextField.text = "wonderfl\n"+"build flash\n"+"online";
            
            
            //キャンバスの生成
            canvas = new BitmapData(textField.width, textField.height);
            canvas.lock();
            canvas.draw(tmpTextField);
            rect = new Rectangle(0, 0, canvas.width, canvas.height);
            point = new Point(0, 0);
            
            //グレースケール
            var grayScaleMatrix:Array = [
                1/3, 1/3, 1/3, 0,   0,
                1/3, 1/3, 1/3, 0,   0,
                1/3, 1/3, 1/3, 0,   0,
                0,   0,   0,   255, 0
            ];
            grayScaleFilter = new ColorMatrixFilter(grayScaleMatrix);
            canvas.applyFilter(canvas, rect, point, grayScaleFilter);
            
            //２値化
            canvas.threshold(canvas, rect, point, "<", 0x00ffffff, 0xff000000, 255, false);
            
            //エッジ検出
            var laplacianMatrix:Array = [
                -1, -1, -1,
                -1, +8, -1,
                -1, -1, -1
            ];
            laplacianFilter = new ConvolutionFilter(3, 3, laplacianMatrix);
            canvas.applyFilter(canvas, rect, point, laplacianFilter);
            
            //ネガポジ反転
            var reverseMatrix:Array = [
                -1, 0, 0, 0, 255,
                0, -1, 0, 0, 255,
                0,  0, -1, 0, 255,
                0,  0,  0, 255, 0
            ]
            reverseFilter = new ColorMatrixFilter(reverseMatrix);
            canvas.applyFilter(canvas, rect, point, reverseFilter);
            
            //キャンバスを表示
            canvas.unlock();
            var bitmap:Bitmap = new Bitmap(canvas);
            bitmap.y = stage.stageHeight / 2;
            addChild(bitmap);
            
            //テキストに変更があるごとに更新
            textField.addEventListener(Event.CHANGE, update);
        }
        
        private function update(e:Event):void {
            tmpTextField.text = textField.text;
            canvas.lock();
            canvas.fillRect(rect, 0xffffffff);
            canvas.draw(tmpTextField);
            canvas.applyFilter(canvas, rect, point, grayScaleFilter);
            canvas.threshold(canvas, rect, point, "<", 0x00ffffff, 0xff000000, 255, false);
            canvas.applyFilter(canvas, rect, point, laplacianFilter);
            canvas.applyFilter(canvas, rect, point, reverseFilter);
            canvas.unlock();
        }
    }
}
