/**
 * Copyright vlad.el.rojo ( http://wonderfl.net/user/vlad.el.rojo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/1tfz
 */

// forked from hiro_rec's flash on 2010-3-6
package
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.BlendMode;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.TimerEvent;
    import flash.filters.BlurFilter;
    import flash.filters.ColorMatrixFilter;
    import flash.filters.GlowFilter;
    import flash.geom.Point;
    import flash.utils.Timer;
    
    
    [SWF(width="400", height="400", frameRate="48", backgroundColor="0x000000")]
    
    public class LineTest06 extends Sprite
    {
        private var lines:Array = [];
        
        private var bmd:BitmapData;
        private var bmp:Bitmap;
        private var container:Sprite;
        
        private var matrix:Array = [
                                1.0, 0, 0, 0, 0,
                                0, 1.1, 0, 0, 0,
                                0, 0, 1.5, 0, 0,
                                0, 0, 0, 0.49, 0
                                ];
            
        private var matrixFilter:ColorMatrixFilter = new ColorMatrixFilter(matrix);
        private var point:Point = new Point();
        private var timer:Timer;
        
        
        public function LineTest06()
        {
            timer = new Timer(100, 20);
            timer.addEventListener(TimerEvent.TIMER, timerHandler);
            timer.start();
            
            container = new Sprite();
            container.x = stage.stageWidth / 2;
            container.y = stage.stageHeight / 2;
            container.rotationY = 90;
            addChild(container);
            
            bmd = new BitmapData(stage.stageWidth, stage.stageHeight, true, 0x00000000);
            bmp = new Bitmap();
            bmp.bitmapData = bmd;
            bmp.blendMode = BlendMode.HARDLIGHT;
            addChild(bmp);
            
            addEventListener(Event.ENTER_FRAME, render);
        }
        
        private function timerHandler(event:TimerEvent):void
        {
            var line:Line = new Line();
            container.addChild(line);
            lines.push(line);
        }
        
        private function render(event:Event):void
        {
            for (var i:int = 0; i < lines.length; i++)
            {
                var line:Line = lines[i];
                line.render();
            }
            
            bmd.draw(stage);
            
            bmd.applyFilter(bmd, bmd.rect, point, matrixFilter);
            bmd.applyFilter(bmd, bmd.rect, point, new GlowFilter(0x0042ff, 0.05, 10, 1, 3));
            bmd.applyFilter(bmd, bmd.rect, point, new BlurFilter(1, 1));
            
            container.rotationY += (stage.mouseX - stage.stageHeight / 2 - container.rotationY) * 0.01;
            container.rotationZ += (stage.mouseY - stage.stageWidth / 2 - container.rotationZ) * 0.01;
        }
    }
}

import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.BlendMode;
import flash.display.Sprite;
import flash.events.Event;
import flash.filters.BlurFilter;
import flash.filters.ColorMatrixFilter;
import flash.filters.GlowFilter;
import flash.geom.Point;
    

class Line extends Sprite
{
    private var points:Array;
    private var index:int = 0;
    
    private var bmd:BitmapData;
    private var bmp:Bitmap;
    
    private var matrix:Array = [
                            1.3, 0, 0, 0, 0,
                            0, 1.0, 0, 0, 0,
                            0, 0, 1.8, 0, 0,
                            0, 0, 0, 0.49, 0
                            ];
        
    private var matrixFilter:ColorMatrixFilter = new ColorMatrixFilter(matrix);
    private var point:Point = new Point();
    private var radius:int = 400;
    
    
    public function Line()
    {
        //filters = [new GlowFilter(0x0078ff, 0.7, 10, 10, 5, 2)];
        
        reset();
    }
    
    private function reset():void
    {
        index = 0;
        points = [];
        
        var len:int = 30;
        
        for (var i:int = 0; i < len; i++)
        {
            points.push(new Point(i * 250 - 2000, Math.random() * 1.5 * (len - i)));
        }
        
        y = Math.sin(Math.PI / 180 * Math.random() * 360) * radius;
        z = Math.cos(Math.PI / 180 * Math.random() * 360) * radius;
    }
    
    public function render():void
    {
        graphics.clear();
        
        setPoints();
        
        index++;
    }
    
    private function setPoints():void
    {
        var v:Vector.<Point> = new Vector.<Point>();
        var len:int = 10;
        
        for (var i:uint; i < len; i++)
        {
            var point:Point = points[i + index];
            
            if (!point)
            {
                reset();
                return;
            }
            
            v[i] = new Point(point.x, point.y);
        }
        
        drawSpline(v);
    }
    
    private function drawSpline(v:Vector.<Point>):void
    {
        if(v.length < 2)
            return;
        
        v.splice(0, 0, v[0]);
        v.push(v[v.length-1]);
        
        var numSegments:uint = 20;//曲線分割数（補完する数）
        
        for(var i:uint=0; i<v.length - 3; i++)
        {
            var p0:Point = v[i];
            var p1:Point = v[i+1];
            var p2:Point = v[i+2];
            var p3:Point = v[i+3];
            splineTo(p0, p1, p2, p3, numSegments);
        }
    }
    
    private function splineTo(p0:Point, p1:Point, p2:Point, p3:Point, numSegments:uint):void
    {
        graphics.moveTo(p1.x, p1.y);
        graphics.lineStyle(2, 0xFFFFFF);
        
        for(var i:uint=0; i<numSegments; i++)
        {
            var t:Number = (i+1)/numSegments;
            graphics.lineTo(catmullRom(p0.x, p1.x, p2.x, p3.x, t), catmullRom(p0.y, p1.y, p2.y, p3.y, t));
        }
    }
    
    public function catmullRom(p0:Number, p1:Number, p2:Number, p3:Number, t:Number):Number
    {
        var v0:Number = (p2 - p0) * 0.5;
        var v1:Number = (p3 - p1) * 0.5;
        
        return (2 * p1 - 2 * p2 + v0 + v1) * t * t * t + (-3 * p1 + 3 * p2 - 2 * v0 - v1) * t * t + v0 * t + p1;
    }
}
