/**
 * Copyright hacker_szoe51ih ( http://wonderfl.net/user/hacker_szoe51ih )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/1ssy
 */

package 
{    
    import caurina.transitions.Tweener;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Loader;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.Matrix;
    import flash.net.*;
    import flash.system.*;
    

    /**
     * ...
     * @author a
     */
    public class Main extends Sprite 
    {    
        public var sp:Sprite;
        public var bmd:BitmapData;
        public var bm:Bitmap;
        public var lo:Loader;
        public var urlReq:URLRequest;
        public var vertices:Vector.<Number>;
        public var indices:Vector.<int>;
        public var uvData:Vector.<Number>;
        public var W:Number=465;
        public var H:Number=465;
        
    
        
        public function Main() {
                
                
                init();
            
        }
        
        public function init():void {
            
            sp = new Sprite();
            sp.x=W/2-400/2;
            sp.y=H/2-300/2;
            addChild(sp);
            sp.addEventListener(MouseEvent.MOUSE_DOWN, mDown);
            stage.addEventListener(MouseEvent.MOUSE_UP, mUp);
            
            lo = new Loader();
            lo.contentLoaderInfo.addEventListener(Event.COMPLETE, onLoaded);
            urlReq=new URLRequest("http://farm5.static.flickr.com/4097/4941567163_0fa5cd2938.jpg");
            var myLoaderContext:LoaderContext = new LoaderContext(true);
            lo.load(urlReq,myLoaderContext);
            
            
        }
        public function onLoaded(e:Event):void {
            
            //ロードしたデータをbmdに描画してbitmapを作る
            bmd = new BitmapData(lo.content.width,lo.content.height);
            var mtx:Matrix = new Matrix();
            mtx.scale(1, 1);
            mtx.rotate(0);
            mtx.translate(0,0);
            bmd.draw(lo.content,mtx);
            bm = new Bitmap(bmd);
            resetDraw();
            
        }
        
        public function resetDraw():void {
            
            vertices = new Vector.<Number>();
            vertices.push(0, 0 ,400, 0);
            vertices.push(200,150);
            vertices.push(0, 300 , 400, 300);
            
            indices = new Vector.<int>();
            indices.push(0, 1, 2);
            indices.push(1, 2, 4);
            indices.push(4, 2, 3);
            indices.push(3, 2, 0);
            
            uvData = new Vector.<Number>();
            uvData.push(0, 0, 1, 0);
            uvData.push(0.5, 0.5);
            uvData.push(0, 1, 1, 1);
            
            updateDraw();
        }
        
        public function updateDraw():void {
            
            sp.graphics.clear();
            sp.graphics.beginBitmapFill(bm.bitmapData);
            sp.graphics.drawTriangles(vertices, indices, uvData);
            sp.graphics.endFill();
            
        }
        
        
        
        //マウスイベント処理
        public function mDown(e:MouseEvent):void {
            
            var uvMouseX:Number = e.localX / sp.width;    
            var uvMouseY:Number = e.localY / sp.height;
            uvData = new Vector.<Number>();
            uvData.push(0, 0, 1, 0);
            uvData.push(uvMouseX, uvMouseY);
            uvData.push(0, 1, 1, 1);
            sp.addEventListener(MouseEvent.MOUSE_MOVE, mMove);
            
        }
        public function mMove(e:MouseEvent):void {
           
            vertices = new Vector.<Number>();
            vertices.push(0, 0 ,400, 0);
            vertices.push(e.localX,e.localY);
            vertices.push(0, 300 , 400, 300);
            updateDraw();
            e.updateAfterEvent();
            
        }
        public function mUp(e:MouseEvent):void {
            
            sp.removeEventListener(MouseEvent.MOUSE_MOVE, mMove);
            resetDraw();
            
            
        }
        
    
        
    
    
    }
}