/**
 * Copyright bradsedito ( http://wonderfl.net/user/bradsedito )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/1sqq
 */

// forked from tkinjo's forked from: ボールを投げる（ブラー追加版）
// forked from tkinjo's ボールを投げる
package 
{
    import flash.display.*;
    import flash.events.*;
    import flash.filters.BlurFilter;
    import flash.geom.*;
    
    [SWF(width="465", height="465", backgroundColor="0xffffff", frameRate="60")] 
    /**
     * ...
     * @author tkinjo
     */
    public class Main extends Sprite 
    {
        private var ball:Ball;
        private var motionBlur:BlurFilter;
        
        public function Main():void 
        {
            ball = new Ball( 20, new Rectangle( 0, 0, stage.stageWidth, stage.stageWidth ) );
            
            var motionBlur:MotionBlur = new MotionBlur( ball, stage.stageWidth, stage.stageHeight );
            addChild( motionBlur );
            addChild( ball );
            
            ball.alpha = 0;
        }
    }
}

import flash.display.*;
import flash.events.*;
import flash.geom.*;
import flash.filters.*;

class MotionBlur extends Sprite {
    
    private const clearColorTranceform:ColorTransform = new ColorTransform( 1, 1, 1, 0 );
    
    private var target:DisplayObject;
    private var targetPreviousX:Number = 0;
    private var targetPreviousY:Number = 0;
    private var targetSpeed:Point = new Point();
    
    private var filterBitmapData:BitmapData;
    private var filterBitmap:Bitmap;
    private var filterContainer:Sprite;
    
    private var matrix:Matrix;
    private var blurFilter:BlurFilter = new BlurFilter( 0, 0 );
    
    public function MotionBlur( target:DisplayObject, width:Number, height:Number ):void {
        
        this.target = target;
        
        filterContainer = new Sprite();
        addChild( filterContainer );
        
        filterBitmapData = new BitmapData( width, height, true, 0 );
        filterBitmap = new Bitmap( filterBitmapData );
        filterBitmap.x = - width / 2;
        filterBitmap.y = - height / 2;
        filterBitmapData.draw( target );
        filterContainer.addChild( filterBitmap );
        
        matrix = new Matrix();
        
        addEventListener(Event.ENTER_FRAME, enterFrameHandler);
    }
    
    private function enterFrameHandler( event:Event ):void {
        
        targetSpeed.x = target.x - targetPreviousX;
        targetSpeed.y = target.y - targetPreviousY;
        
        targetPreviousX = target.x;
        targetPreviousY = target.y;
        
        
        
        filterBitmapData.lock();
        
        filterBitmapData.colorTransform( filterBitmapData.rect, clearColorTranceform );
        
        var direction:Number = Math.atan2( targetSpeed.y, targetSpeed.x );
        
        matrix.identity();
        matrix.rotate( -direction );
        matrix.translate( filterBitmap.width / 2, filterBitmap.height / 2 );
        filterBitmapData.draw( target, matrix );
        
        blurFilter.blurX = targetSpeed.length / 2;
        filterBitmapData.applyFilter( filterBitmapData, filterBitmapData.rect, new Point(), blurFilter );
        
        filterBitmapData.unlock();
        
        
        
        filterContainer.x = target.x - targetSpeed.x;
        filterContainer.y = target.y - targetSpeed.y;
        
        filterContainer.rotation = direction * 180 / Math.PI;
    }
}

class Ball extends Sprite {
    
    private var SPEED_THRESHOLD:Number = 0.1;
    private var FRICTION:Number = 0.05;
    
    private var _speed:Point = new Point();
    public function get speed():Point { return _speed; }
    
    private var previousX:Number = 0;
    private var previousY:Number = 0;
    
    private var mouseDown:Boolean;
    
    private var radius:Number;
    
    private var field:Rectangle;
    
    public function Ball( radius:Number = 20, field:Rectangle = null ):void 
    {
        this.radius = radius;
        this.field = field;
        
        graphics.beginFill( 0 );
        graphics.drawCircle( 0, 0, radius );
        graphics.endFill();
        graphics.beginFill( 0xff0000 );
        graphics.drawCircle( -radius / 2, 0, radius / 2 );
        graphics.endFill();
        graphics.beginFill( 0x00ff00 );
        graphics.drawCircle( radius / 2, 0, radius / 2 );
        graphics.endFill();
        buttonMode = true;
        
        addEventListener(MouseEvent.MOUSE_DOWN, ballMouseDownHandler);
        addEventListener(Event.ENTER_FRAME, enterFrameHandler);
    }
    
    private function enterFrameHandler( event:Event ):void {
        
        if ( !mouseDown ) {
            
            speed.x += -speed.x * FRICTION;
            speed.y += -speed.y * FRICTION;
            
            if ( Math.abs( speed.x ) < SPEED_THRESHOLD )
                speed.x = 0;
            
            if ( Math.abs( speed.y ) < SPEED_THRESHOLD )
                speed.y = 0;
        } else {
            
            speed.x = x - previousX;
            speed.y = y - previousY;
        }
        
        previousX = x;
        previousY = y;
        
        
        
        if ( mouseDown )
            return;
            
        x += speed.x;
        y += speed.y;
        
        
        
        if ( !field )
            return;
        
        if ( x < radius ) {
            
            x = radius;
            speed.x = -speed.x;
        }
        
        if ( field.width - radius < x ) {
            
            x = field.width - radius;
            speed.x = -speed.x;
        }
        
        if ( y < radius ) {
            
            y = radius;
            speed.y = -speed.y;
        }
        
        if ( field.height - radius < y ) {
            
            y = field.height - radius;
            speed.y = -speed.y;
        }
    }
    
    private function ballMouseDownHandler( event:MouseEvent ):void {
        
        mouseDown = true;
        
        stage.addEventListener(MouseEvent.MOUSE_MOVE, stageMouseMoveHandler);
        stage.addEventListener(MouseEvent.MOUSE_UP, stageMouseUpHandler);
    }
    
    private function stageMouseMoveHandler( event:MouseEvent ):void {
        
        x = parent.mouseX;
        y = parent.mouseY;
    }
    
    private function stageMouseUpHandler( event:MouseEvent ):void {
        
        mouseDown = false;
        
        stage.removeEventListener(MouseEvent.MOUSE_MOVE, stageMouseMoveHandler);
        stage.removeEventListener(MouseEvent.MOUSE_UP, stageMouseUpHandler);
    }
}
