/**
 * Copyright nitoyon ( http://wonderfl.net/user/nitoyon )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/1rSf
 */

package{
import flash.display.*;
import flash.events.*;
import flash.geom.*;

[SWF(width=500,height=500,backgroundColor=0x000000, frameRate=12)]
public class TestTriangles extends Sprite{
	private const N:int = 100;
	private const R:int = 200;

	public function TestTriangles(){
		// 100個の点を3D座標空間に作成する
		var points:Vector.<Number> = new Vector.<Number>();
		for(var i:int = 0; i < N; i++){
			points.push(Math.random() * R * 2 - R); // X座標
			points.push(Math.random() * R * 2 - R); // Y座標
			points.push(Math.random() * R * 2 - R); // Z座標
		}

		// 変換行列
		var mtx:Matrix3D = new Matrix3D();

		// 変換結果の座標
		var results:Vector.<Number> = new Vector.<Number>();

		// uvts (projectVectors に渡すが利用はしない)
		var uvts:Vector.<Number> = new Vector.<Number>();

		// 毎フレーム処理
		addEventListener("enterFrame", function(event:Event):void{
			// 変換行列の角度を増やす
			mtx.appendRotation(5, Vector3D.Y_AXIS);
			mtx.appendRotation(3, Vector3D.X_AXIS);
			mtx.appendRotation(2, Vector3D.Z_AXIS);

			// 座標を回転させる
			Utils3D.projectVectors(mtx, points, results, uvts);

			// 描画する
			graphics.clear();
			graphics.beginFill(0xffffff);
			for(var i:int = 0; i < N; i++){
				graphics.drawCircle(results[i * 2] + R, results[i * 2 + 1] + R, 1);
			}
			graphics.endFill();
		});
	}
}
}