/**
 * Copyright zahir ( http://wonderfl.net/user/zahir )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/1rDa
 */

/*
	なんとかASEファイルを吐き出せるような気分
	とりあえずKulerみたいに5個分の色を採ったら保存できます。
 * */
package{
	import com.bit101.components.Label;
	import com.bit101.components.PushButton;
	
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Graphics;
	import flash.display.Loader;
	import flash.display.Shape;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.geom.Matrix;
	import flash.net.FileFilter;
	import flash.net.FileReference;
	import flash.utils.ByteArray;
	import flash.utils.Endian;
	
	
	[SWF(width="465", height="465")]

	public class Create_ase_file extends Sprite{
		private const _filter:Array = [new FileFilter("load Img","*.jpg;*.jpeg;*.png;*.gif")];
		private const max:int = 5;
		private var num:int = 0;
		private var chunks:Array = [];
		
		private var f_name:String;
		
		private var f:FileReference;
		private var l:Loader;
		private var bd:BitmapData;
		private var container:Sprite;
		
		private var btn:PushButton;
		private var sq:Shape;
		
		
		public function Create_ase_file(){
			drawBG();
			var lbl:Label = new Label(this,0,-10, "ASE Generator");
			lbl.scaleX = lbl.scaleY = 3;
			btn = new PushButton(this,0,10,"Load Image");
			btn.x = 465 - btn.width - 5;
			btn.addEventListener(MouseEvent.MOUSE_UP, loadImg);
		}
		private function loadImg(e:MouseEvent):void{
			f = new FileReference();
			f.addEventListener(Event.SELECT, onSelectImg);
			f.browse( _filter );
		}
		private function onSelectImg(e:Event):void{
			btn.removeEventListener( MouseEvent.MOUSE_UP, loadImg );
			btn.label = "";
			f.addEventListener( Event.COMPLETE, onLoadImgComp);
			f.load();
		}
		private function onLoadImgComp(e:Event):void{
			f.removeEventListener(Event.SELECT, onSelectImg);
			f.removeEventListener( Event.COMPLETE, onLoadImgComp);
			
			f_name = f.name.split(".")[0]; // ファイル名から拡張子を取る
			l = new Loader();
			l.contentLoaderInfo.addEventListener(Event.COMPLETE, onComp);
			l.loadBytes( f.data );
		}
		private function onComp(e:Event):void{
			var m:Matrix = new Matrix();
			if(l.width > l.height){
				if(l.width > 256){
					l.width = 256;
					l.scaleY = l.scaleX;
				}
			}else{
				if(l.height > 256){
					l.height = 256;
					l.scaleX = l.scaleY;
				}
			}
			m.scale( l.scaleX, l.scaleY);
			bd = new BitmapData(l.width, l.height, false, 0);
			bd.draw(l,m);
			var bmp:Bitmap = new Bitmap(bd);
			addChild( ( container = new Sprite() ) )
			container.addChild(bmp);
			container.x = (465 - container.width) >>1;
			container.y = (365 - container.height + 220 ) >> 1;
			
			addChild((sq = new Shape()));
			var ct:ColorText = new ColorText();
			addChild(ct);
			ct.x = 52;
			ct.y = 47;
			
			container.addEventListener(MouseEvent.CLICK, addColor );
			container.addEventListener(MouseEvent.MOUSE_MOVE, function(e:MouseEvent):void{
				var c:uint = bd.getPixel(container.mouseX, container.mouseY);
				ct.setColor( c );
				drawSQ(c);
			});
		}
		private function addColor(e:MouseEvent):void{
			if( num >= max) return
			var chunk:ColorChunk = new ColorChunk(bd.getPixel(container.mouseX, container.mouseY));
			chunks[num] = chunk;
			addChild(chunk);
			chunk.x = 100 + num*chunk.width + 5;
			chunk.y = 52;
			num++;
			if(num >= max){
				btn.label = "Save ASE";
				btn.addEventListener( MouseEvent.MOUSE_UP, onSave);
			} 
		}
		private function onSave(e:MouseEvent):void{
			f = new FileReference();
			f.addEventListener(Event.SELECT, function(e:Event):void{});
			var ba:ByteArray = new ByteArray();
			ba.endian = Endian.BIG_ENDIAN;
			ba.writeUTFBytes("ASEF");
			ba.writeShort(1);
			ba.writeShort(0);
			ba.writeInt( max + 1);
			ba.writeShort(0xC001);
			var _name:ByteArray = writeName(f_name);
			ba.writeInt(_name.bytesAvailable + 2);
			ba.writeShort( _name.bytesAvailable/2 );
			ba.writeBytes( _name );
			for(var i:int = 0; i<max; i++){
				var chunk:ColorChunk = chunks[i];
				ba.writeBytes(chunk.getBytes());
			}
			f.save(ba,f_name + ".ase");
		}
		private function drawSQ( color:uint ):void{
			var g:Graphics = sq.graphics;
			g.clear();
			g.beginFill( color );
			g.drawRect(5,50, 46,46);
			g.endFill();
			g.lineStyle( 0, 0x888888 );
			g.drawRect(7,52,41,41);
		}
		private function drawBG():void{
			var g:Graphics = graphics;
			g.beginFill( 0x111111 );
			g.drawRect(0,0, 465,465);
			g.endFill();
			g.lineStyle(0, 0x444444 );
			g.moveTo(5, 35);
			g.lineTo(460, 35);
			g.moveTo(5, 38);
			g.lineTo(460, 38);
			g.moveTo(5, 105);
			g.lineTo(460, 105);
		}
		private function writeName( name:String ):ByteArray{
			var b:ByteArray = new ByteArray();
			var len:int = name.length;
			b = new ByteArray();
			for(var i:int = 0; i<len; i++){
				b.writeShort(name.charCodeAt(i));
			}b.position = 0;
			return b;
		}
	}
}
	import flash.utils.ByteArray;
	import flash.display.Sprite;
	import flash.display.Graphics;
	import flash.display.Shape;
	import flash.text.TextField;
	import flash.text.TextFormat;
class ColorText extends TextField{
	public function ColorText(){
		var f:TextFormat = new TextFormat();
		f.size = 9;
		f.color = 0xCCCCCC;
		defaultTextFormat = f;
	}
	public function setColor(c:uint):void{
		var str:String = "R:" + ((c>>16) &0xFF);
		str += "\nG:" + ((c>>8) & 0xFF);
		str += "\nB:" + (c & 0xFF);
		str += "\n# " + c.toString(16).toUpperCase();
		text = str;
	}
}
class ASE{
}	
class ColorChunk extends Shape{
	private var ba:ByteArray;
	private var _name:ByteArray;
	private var rgb_len:int = 2 + 4 + (4*3) + 2;
	public function ColorChunk(c:uint){
		ba = new ByteArray();
		draw(c);
		writeName( "#" + c.toString(16) );
		 
		ba.writeShort(0x0001);
		ba.writeInt(rgb_len + _name.bytesAvailable);
		ba.writeShort( _name.bytesAvailable/2 );
		ba.writeBytes( _name );
		ba.writeUTFBytes("RGB ");
		ba.writeFloat( ((c>>16) & 0xFF)/255 );
		ba.writeFloat( ((c>>8) & 0xFF)/255 );
		ba.writeFloat( (c & 0xFF) /255);
		ba.writeShort(2);
		ba.position = 0;
	}
	private function draw( color:uint ):void{
		var g:Graphics = graphics;
		g.beginFill( color );
		g.drawRect(0,0,20,20);
		g.endFill();
	}
	private function writeName( name:String ):void{
		var len:int = name.length;
		_name = new ByteArray();
		for(var i:int = 0; i<len; i++){
			_name.writeShort(name.charCodeAt(i));
		}_name.position = 0;
	}
	public function getBytes():ByteArray{
		return ba;
	}
}