/**
 * Copyright tkinjo ( http://wonderfl.net/user/tkinjo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/1qKM
 */

package {
    import flash.display.DisplayObject;
    import flash.display.Loader;
    import flash.display.LoaderInfo;
    import flash.display.Sprite;
    import flash.events.*;
    import flash.net.*;
    import flash.utils.escapeMultiByte;
    import org.libspark.betweenas3.BetweenAS3;

    [SWF(width="465", height="465", backgroundColor="0xffffff", frameRate="60")] 
    /**
     * ...
     * @author tkinjo
     */
    public class Main extends Sprite
    {
        //private const BASE_URL:String = "http://pipes.yahoo.com/pipes/pipe.run?_id=08f23301b0f331eea4b1f44693fba4f8&_render=rss";
        private const BASE_URL:String = "http://pipes.yahooapis.com/pipes/pipe.run?_id=08f23301b0f331eea4b1f44693fba4f8&_render=rss";
        private const URL_PARAM:Array = new Array();
        private const FIND:uint = 12;
        private const IMAGES_OF:String = "graphics";
        private const IMAGE_WIDTH:Number = 75;
        
        private var numHorizontalImage:uint;
        
        private var URL:String = BASE_URL + "&find=" + FIND + "&images_of=" + escapeMultiByte( IMAGES_OF );
        
        private var i:uint = 0;
        
        public function Main()
        {
            numHorizontalImage = stage.stageWidth / 75;
            
            var urlRequest:URLRequest = new URLRequest( URL );
            var urlLoader:URLLoader = new URLLoader();
            
            try {
                urlLoader.load( urlRequest );
            }
            catch (error:SecurityError)
            {
                trace("A SecurityError has occurred.");
                return;
            }
            
            urlLoader.addEventListener( Event.COMPLETE, completeHandler );
        }
        
        private function completeHandler( event:Event ):void {
            
            var urlLoader:URLLoader = event.currentTarget as URLLoader;
            
            try {
                var rss:XML = new XML(urlLoader.data);
                trace( rss );
            }
            catch (error:SecurityError)
            {
                trace("error.");
                return;
            }
            
            var i:uint = 0;
            var media:Namespace = rss.namespace( "media" );
            
            for each( var item:XML in rss.channel.item ){
                
                var url:String = item.media::group.media::thumbnail.@url;
                
                var urlRequest:URLRequest = new URLRequest( url );
                var imageloader:Loader = new Loader();
                imageloader.contentLoaderInfo.addEventListener( Event.COMPLETE, imageLoadCompleteHandler );
                imageloader.load( urlRequest );
            }
        }
        
        private function imageLoadCompleteHandler( event:Event ):void {
            
            var imageLoaderInfo:LoaderInfo = event.currentTarget as LoaderInfo;
            //var image:DisplayObject = imageLoaderInfo.content;
            var image:DisplayObject = imageLoaderInfo.loader;
            addChild( image );
            
            
            image.x = i % numHorizontalImage * IMAGE_WIDTH;
            image.y = uint( i / numHorizontalImage ) * IMAGE_WIDTH;
            BetweenAS3.tween( image, { alpha:1 }, { alpha:0 } ).play();
            i++;
        }
    }
}