/**
 * Copyright heart_thai ( http://wonderfl.net/user/heart_thai )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/1oef
 */

package 
{
	import flash.display.Bitmap;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.display.BitmapData;
	import flash.filters.BlurFilter;
	import flash.geom.Point;
	import flash.geom.Rectangle;
	
	/**
	 * ...
	 * @author narongrit : heart@hotdoflash.net
	 */
	[SWF(frameRate="30",backgroundColor="#FFFFFF")]
	public class Main extends Sprite 
	{
		private var world:Sprite;
		private var bmp:BitmapData;
		
		private var time:Number = 0;
		private var particles:Array;
		
		private var pipe:Number;
		private var blurFilter:BlurFilter = new BlurFilter(10	, 10, 3);
		private var bmpCopy:BitmapData;
		
		private var mouseP:Particle;
		
		//[Embed(source = 'bg.jpg')]
		//private var BG:Class;
		
		public function Main():void 
		{
			if (stage) init();
			else addEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		private function init(e:Event = null):void 
		{
			removeEventListener(Event.ADDED_TO_STAGE, init);
			// entry point
			/*var bg:Bitmap= new BG();
			addChild(bg);
			bg.width = stage.stageWidth;
			bg.height = stage.stageHeight;*/
			
			world = new Sprite();
			
			bmp = new BitmapData(stage.stageWidth , stage.stageHeight, true , 0xFF000000);
			bmpCopy = new BitmapData(stage.stageWidth , stage.stageHeight, true,0xFF000000);
			
			
			var bitmap:Bitmap = new Bitmap(bmp)
			bitmap.cacheAsBitmap = true;
			addChild(bitmap);
			
			/*var b1:Bitmap = new Bitmap(bmpCopy);
			addChild(b1);
			b1.x = 0;
			b1.scaleX = b1.scaleY = 0.3;*/
			
			pipe = stage.stageWidth/2;
			particles = new Array();
			for (var i:int = 0 ; i <= 200 ; i++ ) {
				var p:Particle = new Particle();
				world.addChild(p);
				particles.push(p);
				p.x = pipe + ((Math.random() * 20) -10);
				p.y = -(Math.random() * 1500);
				p.speedY = 3;
				p.speedX = 0;
			}
			
			mouseP = new Particle();
			mouseP.scaleX = mouseP.scaleY = 5;
			mouseP.visible = false;
			world.addChild(mouseP);
			mouseP.startDrag(true);
			
			this.addEventListener(Event.ENTER_FRAME , update );
		}
		private function update(e:Event):void {
			for (var i:String in particles) {
				var sp:Particle = particles[i] as Particle;
				
				sp.y += sp.speedY;
				sp.x += sp.speedX;
				sp.speedY += 0.2;
				
				if (sp.y > stage.stageHeight ) {
					sp.y = -50;
					sp.speedY = 1+(Math.random()*5);
					sp.speedX = 0;
					sp.x = pipe + ((Math.random() * 20) - 10);
				}
				if ( sp.hitTestObject(mouseP)) {
					sp.speedY = -(sp.speedY/4);
					sp.speedX = (Math.random() * 4) - 2;
				}
			}
			
			bmpCopy.fillRect(bmpCopy.rect, 0x00000000);
			bmpCopy.draw(world , null, null, null, new Rectangle(0, 0, stage.stageWidth , stage.stageHeight ), false);
			bmpCopy.applyFilter(bmpCopy , bmpCopy.rect, new Point(0, 0), blurFilter);
			
			
			bmp.fillRect(bmp.rect, 0x00000000);
			bmp.threshold(bmpCopy , bmp.rect ,   new Point() , ">", 0X00FF0000 , 0xEE69b0fe, 0xEEFF0000, false);
			//bmp.applyFilter(bmp, bmp.rect, new Point(), new BlurFilter());
			
			
		}
	}
}

import flash.display.Sprite;

class Particle extends Sprite
	{
		public var speedX:Number;
		public var speedY:Number;
		public function Particle() 
		{
			this.graphics.beginFill(0x00FFFFFF, 0.5);
			this.graphics.drawCircle(0, 0, 2);
		}
		
	}
