/**
 * Copyright chimanaco ( http://wonderfl.net/user/chimanaco )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/1ocD
 */

/**
* ▼元ネタ
* ActionScript3.0入門ノート
*/
package {
    import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
    
	[SWF(width = "465", height = "465", frameRate = "60", backgroundColor = "#000000")]
	public class Ripple extends Sprite {
        private var _num:uint = 7;
		private var _alpha:Number = 1;
		private var _pScale:Number = 2.5;
		private var _mAlpha:Number = .04;
		
		public function Ripple() {
            stage.addEventListener(MouseEvent.MOUSE_MOVE, makeRipple);
            stage.addEventListener(MouseEvent.MOUSE_DOWN, makeRipple);
        }
		//波紋を作成
		private function makeRipple(e:MouseEvent):void {
			for (var i:uint = 1; i < _num; i++) {
				var sp:Sprite = makeSprite();
				drawRing(sp)
			}
		}
		private function makeSprite():Sprite {
			var sp:Sprite = new Sprite();
			addChild(sp);
			sp.x = stage.mouseX;
			sp.y = stage.mouseY;
			sp.addEventListener(Event.ENTER_FRAME, onEnterFrame);
			return sp;
		}
		//円を描く
		private function drawRing(sp:Sprite):void {
			var thickness:uint = Math.random() * 4;
			var color:uint = Math.random() * 0xFFFFFF;
			var r:Number = 1 + Math.random() * 2;
			sp.graphics.lineStyle(thickness, color, _alpha, true, "none");
			sp.graphics.drawCircle(0, 0, r);
		}
		private function onEnterFrame(e:Event):void {
			var sp:Sprite = e.target as Sprite;
			if (sp.alpha > 0) {
				sp.scaleX = sp.scaleY += _pScale;
				sp.alpha -= _mAlpha;
			}else {
				sp.graphics.clear();
				sp.removeEventListener(Event.ENTER_FRAME, onEnterFrame);
				removeChild(sp);
				sp = null;
			}
		}
    }
}