/**
 * Copyright Fricks ( http://wonderfl.net/user/Fricks )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/1nQ6
 */

//ばね運動は色々工夫しないと不規則な動きは難しいっぽいので
//Math.sinを使う感じにしてみた。

package {
    
    import flash.display.Shape;
    import flash.display.Sprite;
    import flash.display.Graphics;
    import flash.events.Event;
    import flash.geom.Point;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    import flash.text.TextFormat;
    
    [SWF(backgroundColor="0xFFFFFF", frameRate="30")] 
          
    public class SpringBall extends Sprite {
        
        private var ball1:Ball;
        private var ball2:Ball;
        private var ball3:Ball;
        private var ball4:Ball;
              
        public function SpringBall() {
            //ボール配置
            this.ball1 = new Ball(0xFF0000);
            this.ball1.x = 50;
            this.ball1.y = 200;
            this.addChild(this.ball1);
            
            this.ball2 = new Ball(0x00FF00);
            this.ball2.x = 175;
            this.ball2.y = 200;
            this.addChild(this.ball2);
            
            this.ball3 = new Ball(0xFF00FF);
            this.ball3.x = 300;
            this.ball3.y = 200;
            this.addChild(this.ball3);
            
            this.ball4 = new Ball(0x00FFFF);
            this.ball4.x = 425;
            this.ball4.y = 200;
            this.addChild(this.ball4);
            
            //アニメーション開始
            this.addEventListener(Event.ENTER_FRAME,this.tick);
            
            //キャプションテキスト
            this.addTextField();
        }
        
        private function tick(e:Event):void{
            //通常
            this.ball1.rad += this.ball1.speed;
            this.ball1.vy = ((Math.sin(this.ball1.rad)*0.5)+1)*this.ball1.dist;
            this.ball1.y += (this.ball1.vy-this.ball1.y)*0.1;
            
            //スピードランダム
            this.ball2.speed = Math.random()*0.5;
            this.ball2.rad += this.ball2.speed;
            this.ball2.vy = ((Math.sin(this.ball2.rad)*0.5)+1)*this.ball2.dist;
            this.ball2.y += (this.ball2.vy-this.ball2.y)*0.1;
            
            //距離ランダム
            this.ball3.dist = 200+Math.random()*50-25;
            this.ball3.rad += this.ball3.speed;
            this.ball3.vy = ((Math.sin(this.ball3.rad)*0.5)+1)*this.ball3.dist;
            this.ball3.y += (this.ball3.vy-this.ball3.y)*0.1;
            
            //スピードランダム 値極小
            this.ball4.speed = Math.random()*0.01;
            this.ball4.rad += this.ball4.speed;
            this.ball4.vy = ((Math.sin(this.ball4.rad)*0.5)+1)*this.ball4.dist;
            this.ball4.y += (this.ball4.vy-this.ball4.y)*0.1;
        }
        
        private function addTextField():void
        {
            var tf:TextFormat = new TextFormat();
            tf.font = "_ゴシック";
            tf.size = 10;
            tf.leading = 1.0;
            tf.align = "center";
            
            var t1:TextField = new TextField();
            t1.defaultTextFormat = tf;
            t1.autoSize = TextFieldAutoSize.LEFT;
            t1.text = "通常";
            t1.x = this.ball1.x-t1.width*0.5;
            t1.y = 150;
            this.addChild(t1);
            
            var t2:TextField = new TextField();
            t2.defaultTextFormat = tf;
            t2.autoSize = "center";
            t2.text = "スピードランダム";
            t2.x = this.ball2.x-t2.width*0.5;
            t2.y = 150;
            this.addChild(t2);
            
            var t3:TextField = new TextField();
            t3.defaultTextFormat = tf;
            t3.autoSize = "center";
            t3.text = "距離ランダム";
            t3.x = this.ball3.x-t3.width*0.5;
            t3.y = 150;
            this.addChild(t3);
            
            var t4:TextField = new TextField();
            t4.defaultTextFormat = tf;
            t4.autoSize = "center";
            t4.text = "スピードランダム\n値極小";
            t4.x = this.ball4.x-t4.width*0.5;
            t4.y = 150;
            this.addChild(t4);
        }
    }
}


import flash.display.Shape;

class Ball extends Shape {
    public var dist:Number = 225;
    public var speed:Number = 0.2;
    public var rad:Number = 0;
    public var vy:Number = 0;
    
    public function Ball(col:int = 0x000000) {
        this.graphics.beginFill(col);
        this.graphics.drawCircle(0,0,25);
        this.graphics.endFill();
    }
}