/**
 * Copyright bongiovi015 ( http://wonderfl.net/user/bongiovi015 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/1nFx
 */

package  {
    import caurina.transitions.Tweener;
    
    import flash.display.BitmapData;
    import flash.display.GradientType;
    import flash.display.Loader;
    import flash.display.Shape;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.IOErrorEvent;
    import flash.events.MouseEvent;
    import flash.events.ProgressEvent;
    import flash.filters.ColorMatrixFilter;
    import flash.geom.Matrix;
    import flash.geom.Point;
    import flash.geom.Rectangle;
    import flash.net.URLRequest;
    import flash.text.TextField;
    import flash.text.TextFormat;
    
    public class Baseball extends Sprite {
    
        //--------------------------------------
        // CLASS CONSTANTS
        //--------------------------------------
        public static const THRESHOLD : Number = 42000;
        public static const MIN_SCALE : Number = .2;
        public static const W : int = 465
        public static const H : int = 465
        public static const RECT : Rectangle = new Rectangle(0, 0, W, H);
        public static const RED    : ColorMatrixFilter = new ColorMatrixFilter( [0, 0, 0, 0, 255,
            0, 0, 0, 0, 0,
            0, 0, 0, 0, 0,
            0, 0, 0, 1, 0]);
        
        
        public var MAX_SCALE : Number = 1;
        private var __bmpdFilled : BitmapData = new BitmapData(W, H, true, 0x00000000);
        private var __scale    : Number = 0;
        private var __first : Boolean = true;
        private var __interline    : int = 20;
        //--------------------------------------
        //  CONSTRUCTOR
        //--------------------------------------
    
        /**
         *    @constructor
         */
        public function Baseball(){

            if(stage) __init();
            else addEventListener( Event.ADDED_TO_STAGE, __init );
            
            var mtx:Matrix = new Matrix;
            mtx.createGradientBox(465, 465, 0);
            graphics.beginGradientFill(GradientType.RADIAL, [0xFFFFFF, 0xCCCCCC], [1, 1], [0, 255], mtx);
            graphics.drawRect(0, 0, 465, 465);
            graphics.endFill();
        }

        private function __init(e:Event=null) : void {
            removeEventListener( Event.ADDED_TO_STAGE, __init );
            
            var tf:TextField = new TextField;
            tf.defaultTextFormat = Invader.FORMAT;
            tf.text = "文";
            __interline = tf.height * MIN_SCALE;
            
            stage.addEventListener(Event.ENTER_FRAME, __loop);
            stage.addEventListener(MouseEvent.CLICK, reset);
        }
        

        
        public function reset(e:Event=null) : void {
            __bmpdFilled.fillRect(RECT, 0);
            while(numChildren>0) removeChildAt(0);
            __first = true;
            MAX_SCALE = 5;
            
            stage.removeEventListener(Event.ENTER_FRAME, __loop);
            stage.addEventListener(Event.ENTER_FRAME, __loop);
        }
        
        
        private function __loop(e:Event) : void {
            var i : int = 0;
            const ITERATION:int = 10;
            while(i++<ITERATION) render();
            
            if(__bmpdFilled.histogram()[3][0] < THRESHOLD){
                stage.removeEventListener(Event.ENTER_FRAME, __loop);
            }
        }
        
        
        public function render() : void {
            __scale = MIN_SCALE;
            var tx:Number, ty:Number;
            const MAX_TRIES : int = 100;
            const INTERLINE : int = 25;
            var numTry:int = 0;
            var invader:Invader = new Invader(0x000000);
            
            do {
                tx = Math.floor(Math.random() * W / __interline) * __interline;
                ty = Math.floor(Math.random() * H / __interline) * __interline;
                numTry++;
                if(numTry > MAX_TRIES) return;
            } while (__bmpdFilled.getPixel32(tx, ty) != 0x00000000 || __bmpdFilled.hitTest(new Point, 255, new Rectangle(tx, ty, invader.width * __scale, invader.height * __scale)));
            
            
            while( !__bmpdFilled.hitTest(new Point, 255, new Rectangle(tx, ty, invader.width * __scale, invader.height * __scale) )  && __scale < MAX_SCALE && tx + invader.width * __scale < stage.stageWidth && ty + invader.height * __scale < stage.stageHeight){
                __scale += .05;
            }
            
            __scale -= 0.05;
            
            __bmpdFilled.fillRect(new Rectangle(tx, ty, invader.width * __scale, invader.height * __scale), 0xFFFFFFFF);
            
            addChild(invader);
            invader.x = tx;
            invader.y = ty;
            invader.alpha = 0;
            invader.scaleX = invader.scaleY = __scale;
            Tweener.addTween(invader, {time:.5, transition:"easeOutSine", alpha:1});
            
            if( __first && __scale >= MAX_SCALE - .5 ) {
                invader.filters = [RED];
                __first = false;
                MAX_SCALE = 2.5;
            }
        }
        
    }

}



import flash.display.Sprite;
import flash.text.TextField;
import flash.text.TextFormat;


class Invader extends Sprite {
    public static const W : int = 10;
    public static const MARGIN : int = 3;
    public static const WIDTH : int = W * 5 + MARGIN * 2;
    
    public static const WORDS : Array = ["王建民","春訓基地","主投","延長","春訓賽","令人驚豔","省球","球團","目標","下班","好球","最快球速","均速","用球數","牛棚","安打","三振","保送","滾飛比","控球","伸卡球","威力","投球內容","球速","模擬","太空人","新秀聯盟","加強控球","重點","進步","變化球","比賽節奏","延長春訓","調整","進度","相當穩定","預計","台灣時間","設定目標","即將","挑戰","先發投手","信心","考驗","躍躍欲試","對戰","連勝","投手","對決","結局","爆冷門","贏","輸","費城人","主場","迎戰","國民","哈勒戴","大聯盟","戲碼","天敵","印地安人","紀錄","打者","苦吞連敗","球迷","防禦率","打擊率","保送","失誤","滾地球","出局數","自責分","連續安打","低潮","無安打","外野飛球","內野","代打","全壘打","連續上壘","最佳戰績","無安打比賽","壓制","完封"];
    public static const FORMAT : TextFormat = new TextFormat("Kozuka Mincho Pro H", 50, 0x000000);
    
    public var color : uint;
    private var __ary : Array = [];
    
    public function Invader(color:uint) : void {
        this.color = color;
        __init();
    }
    
    
    private function __init() : void {
        var tf:TextField = new TextField;
        tf.defaultTextFormat = FORMAT;
        tf.selectable = false;
        tf.multiline = false;
        tf.autoSize = "left";
        addChild(tf);
        tf.text = WORDS[Math.floor(Math.random() * WORDS.length)];
        
        if(Math.random() > .5) {
            tf.text = WORDS[Math.floor(Math.random() * WORDS.length)];
        }else {
            tf.text = getVerticalText(WORDS[Math.floor(Math.random() * WORDS.length)]);
        }
        
    }
    
    
    private function getVerticalText(str:String) : String {
        var s : String = "";
        for ( var i : int = 0; i<str.length; i++) {
            s += str.substring(i, i+1) + "\n";
        }
        return s ;
    }
    
}