/**
 * Copyright sakef ( http://wonderfl.net/user/sakef )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/1n5F
 */

/*
    PV3Dその2
    Line系って面白いですよね。
    もっと面白い利用方法ないですかね。
*/
package
{
    import caurina.transitions.Tweener;    
    import flash.display.Sprite;
    import flash.events.Event;
    import org.papervision3d.cameras.Camera3D;
    import org.papervision3d.core.geom.Lines3D;
    import org.papervision3d.materials.special.LineMaterial;
    import org.papervision3d.objects.DisplayObject3D;
    import org.papervision3d.render.BasicRenderEngine;
    import org.papervision3d.scenes.Scene3D;
    import org.papervision3d.view.Viewport3D;
    
    [SWF(width="465", height="465", backgroundColor="0x000000", frameRate="40")]
    public class Main extends Sprite
    {
        private var viewport:Viewport3D;
        private var scene:Scene3D;
        private var camera:Camera3D;
        private var renderer:BasicRenderEngine;
        private var rootNode:DisplayObject3D;
        private var lines:Array;
        private var dtime:Number;
        private var c:int;
        private static const a:Number=5;
        private static const m:Number=1;
        private static const n:Number=20;
        
        public function Main()
        {
            viewport=new Viewport3D(0, 0, true, true);
            scene=new Scene3D();
            camera=new Camera3D();
            renderer=new BasicRenderEngine();
            rootNode=scene.addChild(new DisplayObject3D("rootNode"));
            
            addChild(viewport);
            camera.zoom=16;
            camera.focus=100;
            camera.target=DisplayObject3D.ZERO;
            
            // ラインの作成
            createLines();
            
            // ラインの削除
            deleteLines();
            
            // イベント
            addEventListener(Event.ENTER_FRAME, onFrame);
        }
        
        // ラインを作成する関数
        private function createLines():void
        {
            var xx:Number=0;
            var yy:Number=0;
            var zz:Number=0;
            dtime = 0;
            c = 0;
            lines = [];
            
            for(var i:Number=0; i <= 12 * Math.PI; i+=0.04)
            {
                var xxx:Number=a * i * Math.sin(m * i) * Math.cos(n * i);
                var yyy:Number=a * i * Math.sin(m * i) * Math.sin(n * i);
                var zzz:Number=a * i * Math.cos(m * i);
                
                var line:Lines3D=new Lines3D(new LineMaterial(HSV2RGB(c % 360, 1, 1), 1));
                line.addNewLine(0.7, xx, yy, zz, xxx, yyy, zzz);
                lines[c] = rootNode.addChild(line);
                line.scale=0;
                Tweener.addTween(line, {scale:1, time:2, delay:dtime});
                dtime+=0.04;
                c++;
                xx=xxx;
                yy=yyy;
                zz=zzz;
            }
        }
        
        // ラインを削除する関数
        private function deleteLines():void
        {
            dtime *= 0.25;
            var t:int=0;
            
            for(var i:int=0; i < c; i++)
            {
                var line:Lines3D=lines[i]as Lines3D;
                Tweener.addTween(line, {scale:0, time:2, delay:dtime, onComplete:function():void
                {
                    var l:Lines3D = (lines[t] as Lines3D);
                    rootNode.removeChild(l);
                    l = null;
                    t++;
                }});
                dtime+=0.04;
            }
        }
        
        // フレーム計算用関数
        public function onFrame(e:Event):void
        {
            rootNode.rotationX+=0.5;
            rootNode.rotationY+=0.5;
            renderer.renderScene(scene, camera, viewport);
            
            trace(rootNode.numChildren);
        }
        
        // HSV → RGB変換関数
        private function HSV2RGB(h:Number, s:Number, v:Number):uint
        {
            if(s == 0) return uint(v*255<<16) | uint(v*255<<8) | uint(v*255);
            else
            {
                var rgb:uint = 0xffffff;
                var hi:int = (h/60)>>0;
                var f:Number = (h/60 - hi);
                var p:Number = v*(1 - s);
                var q:Number = v*(1 - f*s);
                var t:Number = v*(1-(1-f)*s);
                if(hi==0) rgb = uint(v*255<<16) | uint(t*255<<8) | uint(p*255);
                else if(hi==1) rgb = uint(q*255<<16) | uint(v*255<<8) | uint(p*255);
                else if(hi==2) rgb = uint(p*255<<16) | uint(v*255<<8) | uint(t*255);
                else if(hi==3) rgb = uint(p*255<<16) | uint(q*255<<8) | uint(v*255);
                else if(hi==4) rgb = uint(t*255<<16) | uint(p*255<<8) | uint(v*255);
                else if(hi==5) rgb = uint(v*255<<16) | uint(p*255<<8) | uint(q*255);
                return rgb;
            }
        }
    }
}