/**
 * Copyright mezumona ( http://wonderfl.net/user/mezumona )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/1mV9
 */

// forked from mezumona's push() / pop() と [length] / --length のどっちが早い?
/**
 * 
 */
package
{
    import flash.display.Sprite;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    import flash.text.TextFormat;
    import flash.utils.Timer;
    import flash.events.TimerEvent;
    public class PushPopSpeedTest extends Sprite
    {
        public static const LOOP_TIME:int = 20000000;
        private var textField_:TextField = new TextField();
        private var waiter_:Timer = new Timer(1000);

        public function PushPopSpeedTest()
        {
            textField_.autoSize = TextFieldAutoSize.LEFT;
            textField_.defaultTextFormat = new TextFormat("_typewriter", 12);
            addChild(textField_);
            trace("if-else と ifnot-else の比較。");
            trace("試行回数:", LOOP_TIME);
            trace("----");
            waiter_.addEventListener(TimerEvent.TIMER, waiterTimerHandler);
            waiter_.start();
        }

        private function trace(...rest):void
        {
            textField_.appendText(rest.join(" ").concat("\n"));
        }

        private var testCases_:Vector.<Class> = Vector.<Class>([
            IfElseAllTrueCase,
            IfElseAllFlaseCase,
            IfNotElseAllTrueCase,
            IfNotElseAllFalseCase
        ]);
        private var repeatCount_:int = 0;
        private function waiterTimerHandler(event:TimerEvent):void
        {
            if (repeatCount_ < testCases_.length) {
                var testingCase:ITestCase = ITestCase(new testCases_[repeatCount_]());
                trace(testingCase.name, testingCase.exec(LOOP_TIME), "ms");
                
                // また 1 秒後
                waiter_.reset();
                waiter_.start();
                ++repeatCount_;
            }
            // 終了
            else {
                trace("終了。");
                waiter_.stop();
                waiter_.removeEventListener(TimerEvent.TIMER, waiterTimerHandler);
                waiter_ = null;
            }
        }
    }
}

/**
 * テストを実行する時に簡単にできるようにするためのインターフェイスです.
 */
internal interface ITestCase
{
    function get name():String;
    function exec(repeat:int):int;
}

//        if - else
// ------------------------------------------------------------------------------------------------

import flash.utils.getTimer;
/**
 * すべて true の条件を if - else 判定で判定します。
 */
internal class IfElseAllTrueCase implements ITestCase
{
    public function get name():String { return "if - else (all true)  :"; }

    public function cond():Boolean { return true; }

    public function exec(loop:int):int
    {
        var cond:Boolean = cond();
        var i:int = 0;
        var startTime:int = getTimer();
        for (; i < loop; ++i) {
            if (cond) {
                cond;
            }
            else {
                cond = !cond;
            }
        }
        return getTimer() - startTime;
    }
}


import flash.utils.getTimer;
/**
 * すべて false の条件を if - else 判定で判定します。
 */
internal class IfElseAllFlaseCase implements ITestCase
{
    public function get name():String { return "if - else (all false) :"; }

    public function cond():Boolean { return true; }

    public function exec(loop:int):int
    {
        var cond:Boolean = function():Boolean { return false; }();
        var i:int = 0;
        var startTime:int = getTimer();
        for (; i < loop; ++i) {
            if (cond) {
                cond = !cond;
            }
            else {
                cond;
            }
        }
        return getTimer() - startTime;
    }
}

//        ifnot - else
// ------------------------------------------------------------------------------------------import flash.utils.getTimer;
/**
 * すべて true の条件を ifnot - else 判定で判定します。
 */
internal class IfNotElseAllTrueCase implements ITestCase
{
    public function get name():String { return "ifn - else (all true) :"; }

    public function exec(loop:int):int
    {
        var cond:Boolean = function():Boolean { return true; }();
        var i:int = 0;
        var startTime:int = getTimer();
        for (; i < loop; ++i) {
            if (!cond) {
                cond = !cond;
            }
            else {
                cond;
            }
        }
        return getTimer() - startTime;
    }
}

import flash.utils.getTimer;
/**
 * すべて true の条件を ifnot - else 判定で判定します。
 */
internal class IfNotElseAllFalseCase implements ITestCase
{
    public function get name():String { return "ifn - else (all false):"; }

    public function exec(loop:int):int
    {
        var cond:Boolean = function():Boolean { return false; }();
        var i:int = 0;
        var startTime:int = getTimer();
        for (; i < loop; ++i) {
            if (!cond) {
                cond;
            }
            else {
                cond = !cond;
            }
        }
        return getTimer() - startTime;
    }
}